package zio.aws.dataexchange.model
import scala.jdk.CollectionConverters._
sealed trait AssetType {
  def unwrap: software.amazon.awssdk.services.dataexchange.model.AssetType
}
object AssetType {
  def wrap(
      value: software.amazon.awssdk.services.dataexchange.model.AssetType
  ): zio.aws.dataexchange.model.AssetType = value match {
    case software.amazon.awssdk.services.dataexchange.model.AssetType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.dataexchange.model.AssetType.S3_SNAPSHOT =>
      val r = S3_SNAPSHOT
      r
    case software.amazon.awssdk.services.dataexchange.model.AssetType.REDSHIFT_DATA_SHARE =>
      val r = REDSHIFT_DATA_SHARE
      r
    case software.amazon.awssdk.services.dataexchange.model.AssetType.API_GATEWAY_API =>
      val r = API_GATEWAY_API
      r
    case software.amazon.awssdk.services.dataexchange.model.AssetType.S3_DATA_ACCESS =>
      val r = S3_DATA_ACCESS
      r
    case software.amazon.awssdk.services.dataexchange.model.AssetType.LAKE_FORMATION_DATA_PERMISSION =>
      val r = LAKE_FORMATION_DATA_PERMISSION
      r
  }
  case object unknownToSdkVersion extends zio.aws.dataexchange.model.AssetType {
    override def unwrap
        : software.amazon.awssdk.services.dataexchange.model.AssetType =
      software.amazon.awssdk.services.dataexchange.model.AssetType.UNKNOWN_TO_SDK_VERSION
  }
  case object S3_SNAPSHOT extends zio.aws.dataexchange.model.AssetType {
    override def unwrap
        : software.amazon.awssdk.services.dataexchange.model.AssetType =
      software.amazon.awssdk.services.dataexchange.model.AssetType.S3_SNAPSHOT
  }
  case object REDSHIFT_DATA_SHARE extends zio.aws.dataexchange.model.AssetType {
    override def unwrap
        : software.amazon.awssdk.services.dataexchange.model.AssetType =
      software.amazon.awssdk.services.dataexchange.model.AssetType.REDSHIFT_DATA_SHARE
  }
  case object API_GATEWAY_API extends zio.aws.dataexchange.model.AssetType {
    override def unwrap
        : software.amazon.awssdk.services.dataexchange.model.AssetType =
      software.amazon.awssdk.services.dataexchange.model.AssetType.API_GATEWAY_API
  }
  case object S3_DATA_ACCESS extends zio.aws.dataexchange.model.AssetType {
    override def unwrap
        : software.amazon.awssdk.services.dataexchange.model.AssetType =
      software.amazon.awssdk.services.dataexchange.model.AssetType.S3_DATA_ACCESS
  }
  case object LAKE_FORMATION_DATA_PERMISSION
      extends zio.aws.dataexchange.model.AssetType {
    override def unwrap
        : software.amazon.awssdk.services.dataexchange.model.AssetType =
      software.amazon.awssdk.services.dataexchange.model.AssetType.LAKE_FORMATION_DATA_PERMISSION
  }
}
