package zio.aws.dataexchange.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class TableLFTagPolicy(
    expression: Iterable[zio.aws.dataexchange.model.LFTag]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dataexchange.model.TableLFTagPolicy = {
    import TableLFTagPolicy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dataexchange.model.TableLFTagPolicy
      .builder()
      .expression(expression.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.dataexchange.model.TableLFTagPolicy.ReadOnly =
    zio.aws.dataexchange.model.TableLFTagPolicy.wrap(buildAwsValue())
}
object TableLFTagPolicy {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dataexchange.model.TableLFTagPolicy
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dataexchange.model.TableLFTagPolicy =
      zio.aws.dataexchange.model.TableLFTagPolicy(expression.map { item =>
        item.asEditable
      })
    def expression: List[zio.aws.dataexchange.model.LFTag.ReadOnly]
    def getExpression
        : ZIO[Any, Nothing, List[zio.aws.dataexchange.model.LFTag.ReadOnly]] =
      ZIO.succeed(expression)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dataexchange.model.TableLFTagPolicy
  ) extends zio.aws.dataexchange.model.TableLFTagPolicy.ReadOnly {
    override val expression: List[zio.aws.dataexchange.model.LFTag.ReadOnly] =
      impl
        .expression()
        .asScala
        .map { item =>
          zio.aws.dataexchange.model.LFTag.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.dataexchange.model.TableLFTagPolicy
  ): zio.aws.dataexchange.model.TableLFTagPolicy.ReadOnly = new Wrapper(impl)
}
