package zio.aws.dataexchange.model
import scala.jdk.CollectionConverters._
sealed trait JobErrorResourceTypes {
  def unwrap
      : software.amazon.awssdk.services.dataexchange.model.JobErrorResourceTypes
}
object JobErrorResourceTypes {
  def wrap(
      value: software.amazon.awssdk.services.dataexchange.model.JobErrorResourceTypes
  ): zio.aws.dataexchange.model.JobErrorResourceTypes = value match {
    case software.amazon.awssdk.services.dataexchange.model.JobErrorResourceTypes.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.dataexchange.model.JobErrorResourceTypes.REVISION =>
      val r = REVISION
      r
    case software.amazon.awssdk.services.dataexchange.model.JobErrorResourceTypes.ASSET =>
      val r = ASSET
      r
    case software.amazon.awssdk.services.dataexchange.model.JobErrorResourceTypes.DATA_SET =>
      val r = DATA_SET
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.dataexchange.model.JobErrorResourceTypes {
    override def unwrap
        : software.amazon.awssdk.services.dataexchange.model.JobErrorResourceTypes =
      software.amazon.awssdk.services.dataexchange.model.JobErrorResourceTypes.UNKNOWN_TO_SDK_VERSION
  }
  case object REVISION
      extends zio.aws.dataexchange.model.JobErrorResourceTypes {
    override def unwrap
        : software.amazon.awssdk.services.dataexchange.model.JobErrorResourceTypes =
      software.amazon.awssdk.services.dataexchange.model.JobErrorResourceTypes.REVISION
  }
  case object ASSET extends zio.aws.dataexchange.model.JobErrorResourceTypes {
    override def unwrap
        : software.amazon.awssdk.services.dataexchange.model.JobErrorResourceTypes =
      software.amazon.awssdk.services.dataexchange.model.JobErrorResourceTypes.ASSET
  }
  case object DATA_SET
      extends zio.aws.dataexchange.model.JobErrorResourceTypes {
    override def unwrap
        : software.amazon.awssdk.services.dataexchange.model.JobErrorResourceTypes =
      software.amazon.awssdk.services.dataexchange.model.JobErrorResourceTypes.DATA_SET
  }
}
