package zio.aws.dataexchange.model
import zio.aws.dataexchange.model.primitives.{__stringMin10Max512, __string}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class RevokeRevisionRequest(
    dataSetId: __string,
    revisionId: __string,
    revocationComment: __stringMin10Max512
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dataexchange.model.RevokeRevisionRequest = {
    import RevokeRevisionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dataexchange.model.RevokeRevisionRequest
      .builder()
      .dataSetId(dataSetId: java.lang.String)
      .revisionId(revisionId: java.lang.String)
      .revocationComment(revocationComment: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.dataexchange.model.RevokeRevisionRequest.ReadOnly =
    zio.aws.dataexchange.model.RevokeRevisionRequest.wrap(buildAwsValue())
}
object RevokeRevisionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dataexchange.model.RevokeRevisionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dataexchange.model.RevokeRevisionRequest =
      zio.aws.dataexchange.model
        .RevokeRevisionRequest(dataSetId, revisionId, revocationComment)
    def dataSetId: __string
    def revisionId: __string
    def revocationComment: __stringMin10Max512
    def getDataSetId: ZIO[Any, Nothing, __string] = ZIO.succeed(dataSetId)
    def getRevisionId: ZIO[Any, Nothing, __string] = ZIO.succeed(revisionId)
    def getRevocationComment: ZIO[Any, Nothing, __stringMin10Max512] =
      ZIO.succeed(revocationComment)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dataexchange.model.RevokeRevisionRequest
  ) extends zio.aws.dataexchange.model.RevokeRevisionRequest.ReadOnly {
    override val dataSetId: __string = impl.dataSetId(): __string
    override val revisionId: __string = impl.revisionId(): __string
    override val revocationComment: __stringMin10Max512 =
      impl.revocationComment(): __stringMin10Max512
  }
  def wrap(
      impl: software.amazon.awssdk.services.dataexchange.model.RevokeRevisionRequest
  ): zio.aws.dataexchange.model.RevokeRevisionRequest.ReadOnly = new Wrapper(
    impl
  )
}
