package zio.aws.dataexchange.model
import zio.aws.dataexchange.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListRevisionAssetsResponse(
    assets: Optional[Iterable[zio.aws.dataexchange.model.AssetEntry]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dataexchange.model.ListRevisionAssetsResponse = {
    import ListRevisionAssetsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dataexchange.model.ListRevisionAssetsResponse
      .builder()
      .optionallyWith(
        assets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.assets)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.dataexchange.model.ListRevisionAssetsResponse.ReadOnly =
    zio.aws.dataexchange.model.ListRevisionAssetsResponse.wrap(buildAwsValue())
}
object ListRevisionAssetsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dataexchange.model.ListRevisionAssetsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dataexchange.model.ListRevisionAssetsResponse =
      zio.aws.dataexchange.model.ListRevisionAssetsResponse(
        assets.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def assets: Optional[List[zio.aws.dataexchange.model.AssetEntry.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getAssets: ZIO[Any, AwsError, List[
      zio.aws.dataexchange.model.AssetEntry.ReadOnly
    ]] = AwsError.unwrapOptionField("assets", assets)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dataexchange.model.ListRevisionAssetsResponse
  ) extends zio.aws.dataexchange.model.ListRevisionAssetsResponse.ReadOnly {
    override val assets
        : Optional[List[zio.aws.dataexchange.model.AssetEntry.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.assets())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.dataexchange.model.AssetEntry.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.dataexchange.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dataexchange.model.ListRevisionAssetsResponse
  ): zio.aws.dataexchange.model.ListRevisionAssetsResponse.ReadOnly =
    new Wrapper(impl)
}
