package zio.aws.dataexchange.model
import zio.aws.dataexchange.model.primitives.KmsKeyArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class KmsKeyToGrant(kmsKeyArn: KmsKeyArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dataexchange.model.KmsKeyToGrant = {
    import KmsKeyToGrant.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dataexchange.model.KmsKeyToGrant
      .builder()
      .kmsKeyArn(KmsKeyArn.unwrap(kmsKeyArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.dataexchange.model.KmsKeyToGrant.ReadOnly =
    zio.aws.dataexchange.model.KmsKeyToGrant.wrap(buildAwsValue())
}
object KmsKeyToGrant {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dataexchange.model.KmsKeyToGrant
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dataexchange.model.KmsKeyToGrant =
      zio.aws.dataexchange.model.KmsKeyToGrant(kmsKeyArn)
    def kmsKeyArn: KmsKeyArn
    def getKmsKeyArn: ZIO[Any, Nothing, KmsKeyArn] = ZIO.succeed(kmsKeyArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dataexchange.model.KmsKeyToGrant
  ) extends zio.aws.dataexchange.model.KmsKeyToGrant.ReadOnly {
    override val kmsKeyArn: KmsKeyArn =
      zio.aws.dataexchange.model.primitives.KmsKeyArn(impl.kmsKeyArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.dataexchange.model.KmsKeyToGrant
  ): zio.aws.dataexchange.model.KmsKeyToGrant.ReadOnly = new Wrapper(impl)
}
