package zio.aws.dataexchange.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Event(
    revisionPublished: Optional[zio.aws.dataexchange.model.RevisionPublished] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dataexchange.model.Event = {
    import Event.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dataexchange.model.Event
      .builder()
      .optionallyWith(revisionPublished.map(value => value.buildAwsValue()))(
        _.revisionPublished
      )
      .build()
  }
  def asReadOnly: zio.aws.dataexchange.model.Event.ReadOnly =
    zio.aws.dataexchange.model.Event.wrap(buildAwsValue())
}
object Event {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dataexchange.model.Event
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dataexchange.model.Event =
      zio.aws.dataexchange.model
        .Event(revisionPublished.map(value => value.asEditable))
    def revisionPublished
        : Optional[zio.aws.dataexchange.model.RevisionPublished.ReadOnly]
    def getRevisionPublished: ZIO[
      Any,
      AwsError,
      zio.aws.dataexchange.model.RevisionPublished.ReadOnly
    ] = AwsError.unwrapOptionField("revisionPublished", revisionPublished)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dataexchange.model.Event
  ) extends zio.aws.dataexchange.model.Event.ReadOnly {
    override val revisionPublished
        : Optional[zio.aws.dataexchange.model.RevisionPublished.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.revisionPublished())
        .map(value => zio.aws.dataexchange.model.RevisionPublished.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dataexchange.model.Event
  ): zio.aws.dataexchange.model.Event.ReadOnly = new Wrapper(impl)
}
