package zio.aws.dataexchange.model
import zio.aws.dataexchange.model.primitives.{__string, __stringMin0Max16384}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateRevisionRequest(
    comment: Optional[__stringMin0Max16384] = Optional.Absent,
    dataSetId: __string,
    tags: Optional[Map[__string, __string]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dataexchange.model.CreateRevisionRequest = {
    import CreateRevisionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dataexchange.model.CreateRevisionRequest
      .builder()
      .optionallyWith(comment.map(value => value: java.lang.String))(_.comment)
      .dataSetId(dataSetId: java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.dataexchange.model.CreateRevisionRequest.ReadOnly =
    zio.aws.dataexchange.model.CreateRevisionRequest.wrap(buildAwsValue())
}
object CreateRevisionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dataexchange.model.CreateRevisionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dataexchange.model.CreateRevisionRequest =
      zio.aws.dataexchange.model.CreateRevisionRequest(
        comment.map(value => value),
        dataSetId,
        tags.map(value => value)
      )
    def comment: Optional[__stringMin0Max16384]
    def dataSetId: __string
    def tags: Optional[Map[__string, __string]]
    def getComment: ZIO[Any, AwsError, __stringMin0Max16384] =
      AwsError.unwrapOptionField("comment", comment)
    def getDataSetId: ZIO[Any, Nothing, __string] = ZIO.succeed(dataSetId)
    def getTags: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dataexchange.model.CreateRevisionRequest
  ) extends zio.aws.dataexchange.model.CreateRevisionRequest.ReadOnly {
    override val comment: Optional[__stringMin0Max16384] = zio.aws.core.internal
      .optionalFromNullable(impl.comment())
      .map(value => value: __stringMin0Max16384)
    override val dataSetId: __string = impl.dataSetId(): __string
    override val tags: Optional[Map[__string, __string]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: __string) -> (value: __string)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.dataexchange.model.CreateRevisionRequest
  ): zio.aws.dataexchange.model.CreateRevisionRequest.ReadOnly = new Wrapper(
    impl
  )
}
