package zio.aws.dataexchange.model
import zio.aws.dataexchange.model.primitives.{Name, Description, __string}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateDataSetRequest(
    dataSetId: __string,
    description: Optional[Description] = Optional.Absent,
    name: Optional[Name] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dataexchange.model.UpdateDataSetRequest = {
    import UpdateDataSetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dataexchange.model.UpdateDataSetRequest
      .builder()
      .dataSetId(dataSetId: java.lang.String)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .build()
  }
  def asReadOnly: zio.aws.dataexchange.model.UpdateDataSetRequest.ReadOnly =
    zio.aws.dataexchange.model.UpdateDataSetRequest.wrap(buildAwsValue())
}
object UpdateDataSetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dataexchange.model.UpdateDataSetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dataexchange.model.UpdateDataSetRequest =
      zio.aws.dataexchange.model.UpdateDataSetRequest(
        dataSetId,
        description.map(value => value),
        name.map(value => value)
      )
    def dataSetId: __string
    def description: Optional[Description]
    def name: Optional[Name]
    def getDataSetId: ZIO[Any, Nothing, __string] = ZIO.succeed(dataSetId)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dataexchange.model.UpdateDataSetRequest
  ) extends zio.aws.dataexchange.model.UpdateDataSetRequest.ReadOnly {
    override val dataSetId: __string = impl.dataSetId(): __string
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.dataexchange.model.primitives.Description(value))
    override val name: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.dataexchange.model.primitives.Name(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dataexchange.model.UpdateDataSetRequest
  ): zio.aws.dataexchange.model.UpdateDataSetRequest.ReadOnly = new Wrapper(
    impl
  )
}
