package zio.aws.dataexchange.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.dataexchange.model.primitives.{AssetName, Id, Timestamp, Arn}
import scala.jdk.CollectionConverters._
final case class GetAssetResponse(
    arn: Optional[Arn] = Optional.Absent,
    assetDetails: Optional[zio.aws.dataexchange.model.AssetDetails] =
      Optional.Absent,
    assetType: Optional[zio.aws.dataexchange.model.AssetType] = Optional.Absent,
    createdAt: Optional[Timestamp] = Optional.Absent,
    dataSetId: Optional[Id] = Optional.Absent,
    id: Optional[Id] = Optional.Absent,
    name: Optional[AssetName] = Optional.Absent,
    revisionId: Optional[Id] = Optional.Absent,
    sourceId: Optional[Id] = Optional.Absent,
    updatedAt: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dataexchange.model.GetAssetResponse = {
    import GetAssetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dataexchange.model.GetAssetResponse
      .builder()
      .optionallyWith(arn.map(value => Arn.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(assetDetails.map(value => value.buildAwsValue()))(
        _.assetDetails
      )
      .optionallyWith(assetType.map(value => value.unwrap))(_.assetType)
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(
        dataSetId.map(value => Id.unwrap(value): java.lang.String)
      )(_.dataSetId)
      .optionallyWith(id.map(value => Id.unwrap(value): java.lang.String))(_.id)
      .optionallyWith(
        name.map(value => AssetName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        revisionId.map(value => Id.unwrap(value): java.lang.String)
      )(_.revisionId)
      .optionallyWith(
        sourceId.map(value => Id.unwrap(value): java.lang.String)
      )(_.sourceId)
      .optionallyWith(updatedAt.map(value => Timestamp.unwrap(value): Instant))(
        _.updatedAt
      )
      .build()
  }
  def asReadOnly: zio.aws.dataexchange.model.GetAssetResponse.ReadOnly =
    zio.aws.dataexchange.model.GetAssetResponse.wrap(buildAwsValue())
}
object GetAssetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dataexchange.model.GetAssetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dataexchange.model.GetAssetResponse =
      zio.aws.dataexchange.model.GetAssetResponse(
        arn.map(value => value),
        assetDetails.map(value => value.asEditable),
        assetType.map(value => value),
        createdAt.map(value => value),
        dataSetId.map(value => value),
        id.map(value => value),
        name.map(value => value),
        revisionId.map(value => value),
        sourceId.map(value => value),
        updatedAt.map(value => value)
      )
    def arn: Optional[Arn]
    def assetDetails: Optional[zio.aws.dataexchange.model.AssetDetails.ReadOnly]
    def assetType: Optional[zio.aws.dataexchange.model.AssetType]
    def createdAt: Optional[Timestamp]
    def dataSetId: Optional[Id]
    def id: Optional[Id]
    def name: Optional[AssetName]
    def revisionId: Optional[Id]
    def sourceId: Optional[Id]
    def updatedAt: Optional[Timestamp]
    def getArn: ZIO[Any, AwsError, Arn] = AwsError.unwrapOptionField("arn", arn)
    def getAssetDetails
        : ZIO[Any, AwsError, zio.aws.dataexchange.model.AssetDetails.ReadOnly] =
      AwsError.unwrapOptionField("assetDetails", assetDetails)
    def getAssetType: ZIO[Any, AwsError, zio.aws.dataexchange.model.AssetType] =
      AwsError.unwrapOptionField("assetType", assetType)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getDataSetId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("dataSetId", dataSetId)
    def getId: ZIO[Any, AwsError, Id] = AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, AssetName] =
      AwsError.unwrapOptionField("name", name)
    def getRevisionId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("revisionId", revisionId)
    def getSourceId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("sourceId", sourceId)
    def getUpdatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("updatedAt", updatedAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dataexchange.model.GetAssetResponse
  ) extends zio.aws.dataexchange.model.GetAssetResponse.ReadOnly {
    override val arn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.dataexchange.model.primitives.Arn(value))
    override val assetDetails
        : Optional[zio.aws.dataexchange.model.AssetDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.assetDetails())
        .map(value => zio.aws.dataexchange.model.AssetDetails.wrap(value))
    override val assetType: Optional[zio.aws.dataexchange.model.AssetType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.assetType())
        .map(value => zio.aws.dataexchange.model.AssetType.wrap(value))
    override val createdAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.dataexchange.model.primitives.Timestamp(value))
    override val dataSetId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.dataSetId())
      .map(value => zio.aws.dataexchange.model.primitives.Id(value))
    override val id: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.dataexchange.model.primitives.Id(value))
    override val name: Optional[AssetName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.dataexchange.model.primitives.AssetName(value))
    override val revisionId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.revisionId())
      .map(value => zio.aws.dataexchange.model.primitives.Id(value))
    override val sourceId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceId())
      .map(value => zio.aws.dataexchange.model.primitives.Id(value))
    override val updatedAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.updatedAt())
      .map(value => zio.aws.dataexchange.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dataexchange.model.GetAssetResponse
  ): zio.aws.dataexchange.model.GetAssetResponse.ReadOnly = new Wrapper(impl)
}
