package zio.aws.dataexchange.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.dataexchange.model.primitives.{
  Timestamp,
  Arn,
  Description,
  Name,
  Id
}
import scala.jdk.CollectionConverters._
final case class DataSetEntry(
    arn: Arn,
    assetType: zio.aws.dataexchange.model.AssetType,
    createdAt: Timestamp,
    description: Description,
    id: Id,
    name: Name,
    origin: zio.aws.dataexchange.model.Origin,
    originDetails: Optional[zio.aws.dataexchange.model.OriginDetails] =
      Optional.Absent,
    sourceId: Optional[Id] = Optional.Absent,
    updatedAt: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dataexchange.model.DataSetEntry = {
    import DataSetEntry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dataexchange.model.DataSetEntry
      .builder()
      .arn(Arn.unwrap(arn): java.lang.String)
      .assetType(assetType.unwrap)
      .createdAt(Timestamp.unwrap(createdAt): Instant)
      .description(Description.unwrap(description): java.lang.String)
      .id(Id.unwrap(id): java.lang.String)
      .name(Name.unwrap(name): java.lang.String)
      .origin(origin.unwrap)
      .optionallyWith(originDetails.map(value => value.buildAwsValue()))(
        _.originDetails
      )
      .optionallyWith(
        sourceId.map(value => Id.unwrap(value): java.lang.String)
      )(_.sourceId)
      .updatedAt(Timestamp.unwrap(updatedAt): Instant)
      .build()
  }
  def asReadOnly: zio.aws.dataexchange.model.DataSetEntry.ReadOnly =
    zio.aws.dataexchange.model.DataSetEntry.wrap(buildAwsValue())
}
object DataSetEntry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dataexchange.model.DataSetEntry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dataexchange.model.DataSetEntry =
      zio.aws.dataexchange.model.DataSetEntry(
        arn,
        assetType,
        createdAt,
        description,
        id,
        name,
        origin,
        originDetails.map(value => value.asEditable),
        sourceId.map(value => value),
        updatedAt
      )
    def arn: Arn
    def assetType: zio.aws.dataexchange.model.AssetType
    def createdAt: Timestamp
    def description: Description
    def id: Id
    def name: Name
    def origin: zio.aws.dataexchange.model.Origin
    def originDetails
        : Optional[zio.aws.dataexchange.model.OriginDetails.ReadOnly]
    def sourceId: Optional[Id]
    def updatedAt: Timestamp
    def getArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(arn)
    def getAssetType: ZIO[Any, Nothing, zio.aws.dataexchange.model.AssetType] =
      ZIO.succeed(assetType)
    def getCreatedAt: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(createdAt)
    def getDescription: ZIO[Any, Nothing, Description] =
      ZIO.succeed(description)
    def getId: ZIO[Any, Nothing, Id] = ZIO.succeed(id)
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getOrigin: ZIO[Any, Nothing, zio.aws.dataexchange.model.Origin] =
      ZIO.succeed(origin)
    def getOriginDetails: ZIO[
      Any,
      AwsError,
      zio.aws.dataexchange.model.OriginDetails.ReadOnly
    ] = AwsError.unwrapOptionField("originDetails", originDetails)
    def getSourceId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("sourceId", sourceId)
    def getUpdatedAt: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(updatedAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dataexchange.model.DataSetEntry
  ) extends zio.aws.dataexchange.model.DataSetEntry.ReadOnly {
    override val arn: Arn =
      zio.aws.dataexchange.model.primitives.Arn(impl.arn())
    override val assetType: zio.aws.dataexchange.model.AssetType =
      zio.aws.dataexchange.model.AssetType.wrap(impl.assetType())
    override val createdAt: Timestamp =
      zio.aws.dataexchange.model.primitives.Timestamp(impl.createdAt())
    override val description: Description =
      zio.aws.dataexchange.model.primitives.Description(impl.description())
    override val id: Id = zio.aws.dataexchange.model.primitives.Id(impl.id())
    override val name: Name =
      zio.aws.dataexchange.model.primitives.Name(impl.name())
    override val origin: zio.aws.dataexchange.model.Origin =
      zio.aws.dataexchange.model.Origin.wrap(impl.origin())
    override val originDetails
        : Optional[zio.aws.dataexchange.model.OriginDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.originDetails())
        .map(value => zio.aws.dataexchange.model.OriginDetails.wrap(value))
    override val sourceId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceId())
      .map(value => zio.aws.dataexchange.model.primitives.Id(value))
    override val updatedAt: Timestamp =
      zio.aws.dataexchange.model.primitives.Timestamp(impl.updatedAt())
  }
  def wrap(
      impl: software.amazon.awssdk.services.dataexchange.model.DataSetEntry
  ): zio.aws.dataexchange.model.DataSetEntry.ReadOnly = new Wrapper(impl)
}
