package zio.aws.dataexchange.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class TableLFTagPolicyAndPermissions(
    expression: Iterable[zio.aws.dataexchange.model.LFTag],
    permissions: Iterable[zio.aws.dataexchange.model.TableTagPolicyLFPermission]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dataexchange.model.TableLFTagPolicyAndPermissions = {
    import TableLFTagPolicyAndPermissions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dataexchange.model.TableLFTagPolicyAndPermissions
      .builder()
      .expression(expression.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .permissionsWithStrings(permissions.map { item =>
        item.unwrap.toString
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.dataexchange.model.TableLFTagPolicyAndPermissions.ReadOnly =
    zio.aws.dataexchange.model.TableLFTagPolicyAndPermissions
      .wrap(buildAwsValue())
}
object TableLFTagPolicyAndPermissions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dataexchange.model.TableLFTagPolicyAndPermissions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dataexchange.model.TableLFTagPolicyAndPermissions =
      zio.aws.dataexchange.model.TableLFTagPolicyAndPermissions(
        expression.map { item =>
          item.asEditable
        },
        permissions
      )
    def expression: List[zio.aws.dataexchange.model.LFTag.ReadOnly]
    def permissions: List[zio.aws.dataexchange.model.TableTagPolicyLFPermission]
    def getExpression
        : ZIO[Any, Nothing, List[zio.aws.dataexchange.model.LFTag.ReadOnly]] =
      ZIO.succeed(expression)
    def getPermissions: ZIO[Any, Nothing, List[
      zio.aws.dataexchange.model.TableTagPolicyLFPermission
    ]] = ZIO.succeed(permissions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dataexchange.model.TableLFTagPolicyAndPermissions
  ) extends zio.aws.dataexchange.model.TableLFTagPolicyAndPermissions.ReadOnly {
    override val expression: List[zio.aws.dataexchange.model.LFTag.ReadOnly] =
      impl
        .expression()
        .asScala
        .map { item =>
          zio.aws.dataexchange.model.LFTag.wrap(item)
        }
        .toList
    override val permissions
        : List[zio.aws.dataexchange.model.TableTagPolicyLFPermission] = impl
      .permissions()
      .asScala
      .map { item =>
        zio.aws.dataexchange.model.TableTagPolicyLFPermission.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.dataexchange.model.TableLFTagPolicyAndPermissions
  ): zio.aws.dataexchange.model.TableLFTagPolicyAndPermissions.ReadOnly =
    new Wrapper(impl)
}
