package zio.aws.dataexchange.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class LFResourceDetails(
    database: Optional[zio.aws.dataexchange.model.DatabaseLFTagPolicy] =
      Optional.Absent,
    table: Optional[zio.aws.dataexchange.model.TableLFTagPolicy] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dataexchange.model.LFResourceDetails = {
    import LFResourceDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dataexchange.model.LFResourceDetails
      .builder()
      .optionallyWith(database.map(value => value.buildAwsValue()))(_.database)
      .optionallyWith(table.map(value => value.buildAwsValue()))(_.table)
      .build()
  }
  def asReadOnly: zio.aws.dataexchange.model.LFResourceDetails.ReadOnly =
    zio.aws.dataexchange.model.LFResourceDetails.wrap(buildAwsValue())
}
object LFResourceDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dataexchange.model.LFResourceDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dataexchange.model.LFResourceDetails =
      zio.aws.dataexchange.model.LFResourceDetails(
        database.map(value => value.asEditable),
        table.map(value => value.asEditable)
      )
    def database
        : Optional[zio.aws.dataexchange.model.DatabaseLFTagPolicy.ReadOnly]
    def table: Optional[zio.aws.dataexchange.model.TableLFTagPolicy.ReadOnly]
    def getDatabase: ZIO[
      Any,
      AwsError,
      zio.aws.dataexchange.model.DatabaseLFTagPolicy.ReadOnly
    ] = AwsError.unwrapOptionField("database", database)
    def getTable: ZIO[
      Any,
      AwsError,
      zio.aws.dataexchange.model.TableLFTagPolicy.ReadOnly
    ] = AwsError.unwrapOptionField("table", table)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dataexchange.model.LFResourceDetails
  ) extends zio.aws.dataexchange.model.LFResourceDetails.ReadOnly {
    override val database
        : Optional[zio.aws.dataexchange.model.DatabaseLFTagPolicy.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.database())
        .map(value =>
          zio.aws.dataexchange.model.DatabaseLFTagPolicy.wrap(value)
        )
    override val table
        : Optional[zio.aws.dataexchange.model.TableLFTagPolicy.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.table())
        .map(value => zio.aws.dataexchange.model.TableLFTagPolicy.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dataexchange.model.LFResourceDetails
  ): zio.aws.dataexchange.model.LFResourceDetails.ReadOnly = new Wrapper(impl)
}
