package zio.aws.dataexchange.model
import zio.aws.dataexchange.model.primitives.{Id, RoleArn, AwsAccountId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ImportAssetsFromLakeFormationTagPolicyRequestDetails(
    catalogId: AwsAccountId,
    database: Optional[
      zio.aws.dataexchange.model.DatabaseLFTagPolicyAndPermissions
    ] = Optional.Absent,
    table: Optional[zio.aws.dataexchange.model.TableLFTagPolicyAndPermissions] =
      Optional.Absent,
    roleArn: RoleArn,
    dataSetId: Id,
    revisionId: Id
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dataexchange.model.ImportAssetsFromLakeFormationTagPolicyRequestDetails = {
    import ImportAssetsFromLakeFormationTagPolicyRequestDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dataexchange.model.ImportAssetsFromLakeFormationTagPolicyRequestDetails
      .builder()
      .catalogId(AwsAccountId.unwrap(catalogId): java.lang.String)
      .optionallyWith(database.map(value => value.buildAwsValue()))(_.database)
      .optionallyWith(table.map(value => value.buildAwsValue()))(_.table)
      .roleArn(RoleArn.unwrap(roleArn): java.lang.String)
      .dataSetId(Id.unwrap(dataSetId): java.lang.String)
      .revisionId(Id.unwrap(revisionId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.dataexchange.model.ImportAssetsFromLakeFormationTagPolicyRequestDetails.ReadOnly =
    zio.aws.dataexchange.model.ImportAssetsFromLakeFormationTagPolicyRequestDetails
      .wrap(buildAwsValue())
}
object ImportAssetsFromLakeFormationTagPolicyRequestDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dataexchange.model.ImportAssetsFromLakeFormationTagPolicyRequestDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.dataexchange.model.ImportAssetsFromLakeFormationTagPolicyRequestDetails =
      zio.aws.dataexchange.model
        .ImportAssetsFromLakeFormationTagPolicyRequestDetails(
          catalogId,
          database.map(value => value.asEditable),
          table.map(value => value.asEditable),
          roleArn,
          dataSetId,
          revisionId
        )
    def catalogId: AwsAccountId
    def database: Optional[
      zio.aws.dataexchange.model.DatabaseLFTagPolicyAndPermissions.ReadOnly
    ]
    def table: Optional[
      zio.aws.dataexchange.model.TableLFTagPolicyAndPermissions.ReadOnly
    ]
    def roleArn: RoleArn
    def dataSetId: Id
    def revisionId: Id
    def getCatalogId: ZIO[Any, Nothing, AwsAccountId] = ZIO.succeed(catalogId)
    def getDatabase: ZIO[
      Any,
      AwsError,
      zio.aws.dataexchange.model.DatabaseLFTagPolicyAndPermissions.ReadOnly
    ] = AwsError.unwrapOptionField("database", database)
    def getTable: ZIO[
      Any,
      AwsError,
      zio.aws.dataexchange.model.TableLFTagPolicyAndPermissions.ReadOnly
    ] = AwsError.unwrapOptionField("table", table)
    def getRoleArn: ZIO[Any, Nothing, RoleArn] = ZIO.succeed(roleArn)
    def getDataSetId: ZIO[Any, Nothing, Id] = ZIO.succeed(dataSetId)
    def getRevisionId: ZIO[Any, Nothing, Id] = ZIO.succeed(revisionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dataexchange.model.ImportAssetsFromLakeFormationTagPolicyRequestDetails
  ) extends zio.aws.dataexchange.model.ImportAssetsFromLakeFormationTagPolicyRequestDetails.ReadOnly {
    override val catalogId: AwsAccountId =
      zio.aws.dataexchange.model.primitives.AwsAccountId(impl.catalogId())
    override val database: Optional[
      zio.aws.dataexchange.model.DatabaseLFTagPolicyAndPermissions.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.database())
      .map(value =>
        zio.aws.dataexchange.model.DatabaseLFTagPolicyAndPermissions.wrap(value)
      )
    override val table: Optional[
      zio.aws.dataexchange.model.TableLFTagPolicyAndPermissions.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.table())
      .map(value =>
        zio.aws.dataexchange.model.TableLFTagPolicyAndPermissions.wrap(value)
      )
    override val roleArn: RoleArn =
      zio.aws.dataexchange.model.primitives.RoleArn(impl.roleArn())
    override val dataSetId: Id =
      zio.aws.dataexchange.model.primitives.Id(impl.dataSetId())
    override val revisionId: Id =
      zio.aws.dataexchange.model.primitives.Id(impl.revisionId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.dataexchange.model.ImportAssetsFromLakeFormationTagPolicyRequestDetails
  ): zio.aws.dataexchange.model.ImportAssetsFromLakeFormationTagPolicyRequestDetails.ReadOnly =
    new Wrapper(impl)
}
