package zio.aws.dataexchange.model
import zio.aws.dataexchange.model.primitives.{__string, Id}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ExportRevisionsToS3ResponseDetails(
    dataSetId: Id,
    encryption: Optional[
      zio.aws.dataexchange.model.ExportServerSideEncryption
    ] = Optional.Absent,
    revisionDestinations: Iterable[
      zio.aws.dataexchange.model.RevisionDestinationEntry
    ],
    eventActionArn: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dataexchange.model.ExportRevisionsToS3ResponseDetails = {
    import ExportRevisionsToS3ResponseDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dataexchange.model.ExportRevisionsToS3ResponseDetails
      .builder()
      .dataSetId(Id.unwrap(dataSetId): java.lang.String)
      .optionallyWith(encryption.map(value => value.buildAwsValue()))(
        _.encryption
      )
      .revisionDestinations(revisionDestinations.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(eventActionArn.map(value => value: java.lang.String))(
        _.eventActionArn
      )
      .build()
  }
  def asReadOnly
      : zio.aws.dataexchange.model.ExportRevisionsToS3ResponseDetails.ReadOnly =
    zio.aws.dataexchange.model.ExportRevisionsToS3ResponseDetails
      .wrap(buildAwsValue())
}
object ExportRevisionsToS3ResponseDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dataexchange.model.ExportRevisionsToS3ResponseDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.dataexchange.model.ExportRevisionsToS3ResponseDetails =
      zio.aws.dataexchange.model.ExportRevisionsToS3ResponseDetails(
        dataSetId,
        encryption.map(value => value.asEditable),
        revisionDestinations.map { item =>
          item.asEditable
        },
        eventActionArn.map(value => value)
      )
    def dataSetId: Id
    def encryption: Optional[
      zio.aws.dataexchange.model.ExportServerSideEncryption.ReadOnly
    ]
    def revisionDestinations
        : List[zio.aws.dataexchange.model.RevisionDestinationEntry.ReadOnly]
    def eventActionArn: Optional[__string]
    def getDataSetId: ZIO[Any, Nothing, Id] = ZIO.succeed(dataSetId)
    def getEncryption: ZIO[
      Any,
      AwsError,
      zio.aws.dataexchange.model.ExportServerSideEncryption.ReadOnly
    ] = AwsError.unwrapOptionField("encryption", encryption)
    def getRevisionDestinations: ZIO[Any, Nothing, List[
      zio.aws.dataexchange.model.RevisionDestinationEntry.ReadOnly
    ]] = ZIO.succeed(revisionDestinations)
    def getEventActionArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("eventActionArn", eventActionArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dataexchange.model.ExportRevisionsToS3ResponseDetails
  ) extends zio.aws.dataexchange.model.ExportRevisionsToS3ResponseDetails.ReadOnly {
    override val dataSetId: Id =
      zio.aws.dataexchange.model.primitives.Id(impl.dataSetId())
    override val encryption: Optional[
      zio.aws.dataexchange.model.ExportServerSideEncryption.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.encryption())
      .map(value =>
        zio.aws.dataexchange.model.ExportServerSideEncryption.wrap(value)
      )
    override val revisionDestinations
        : List[zio.aws.dataexchange.model.RevisionDestinationEntry.ReadOnly] =
      impl
        .revisionDestinations()
        .asScala
        .map { item =>
          zio.aws.dataexchange.model.RevisionDestinationEntry.wrap(item)
        }
        .toList
    override val eventActionArn: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.eventActionArn())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.dataexchange.model.ExportRevisionsToS3ResponseDetails
  ): zio.aws.dataexchange.model.ExportRevisionsToS3ResponseDetails.ReadOnly =
    new Wrapper(impl)
}
