package zio.aws.dataexchange.model
import scala.jdk.CollectionConverters._
sealed trait ProtocolType {
  def unwrap: software.amazon.awssdk.services.dataexchange.model.ProtocolType
}
object ProtocolType {
  def wrap(
      value: software.amazon.awssdk.services.dataexchange.model.ProtocolType
  ): zio.aws.dataexchange.model.ProtocolType = value match {
    case software.amazon.awssdk.services.dataexchange.model.ProtocolType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.dataexchange.model.ProtocolType.REST =>
      val r = REST
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.dataexchange.model.ProtocolType {
    override def unwrap
        : software.amazon.awssdk.services.dataexchange.model.ProtocolType =
      software.amazon.awssdk.services.dataexchange.model.ProtocolType.UNKNOWN_TO_SDK_VERSION
  }
  case object REST extends zio.aws.dataexchange.model.ProtocolType {
    override def unwrap
        : software.amazon.awssdk.services.dataexchange.model.ProtocolType =
      software.amazon.awssdk.services.dataexchange.model.ProtocolType.REST
  }
}
