package zio.aws.dataexchange.model
import scala.jdk.CollectionConverters._
sealed trait Origin {
  def unwrap: software.amazon.awssdk.services.dataexchange.model.Origin
}
object Origin {
  def wrap(
      value: software.amazon.awssdk.services.dataexchange.model.Origin
  ): zio.aws.dataexchange.model.Origin = value match {
    case software.amazon.awssdk.services.dataexchange.model.Origin.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.dataexchange.model.Origin.OWNED =>
      val r = OWNED
      r
    case software.amazon.awssdk.services.dataexchange.model.Origin.ENTITLED =>
      val r = ENTITLED
      r
  }
  case object unknownToSdkVersion extends zio.aws.dataexchange.model.Origin {
    override def unwrap
        : software.amazon.awssdk.services.dataexchange.model.Origin =
      software.amazon.awssdk.services.dataexchange.model.Origin.UNKNOWN_TO_SDK_VERSION
  }
  case object OWNED extends zio.aws.dataexchange.model.Origin {
    override def unwrap
        : software.amazon.awssdk.services.dataexchange.model.Origin =
      software.amazon.awssdk.services.dataexchange.model.Origin.OWNED
  }
  case object ENTITLED extends zio.aws.dataexchange.model.Origin {
    override def unwrap
        : software.amazon.awssdk.services.dataexchange.model.Origin =
      software.amazon.awssdk.services.dataexchange.model.Origin.ENTITLED
  }
}
