package zio.aws.dataexchange.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CreateEventActionRequest(
    action: zio.aws.dataexchange.model.Action,
    event: zio.aws.dataexchange.model.Event
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dataexchange.model.CreateEventActionRequest = {
    import CreateEventActionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dataexchange.model.CreateEventActionRequest
      .builder()
      .action(action.buildAwsValue())
      .event(event.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.dataexchange.model.CreateEventActionRequest.ReadOnly =
    zio.aws.dataexchange.model.CreateEventActionRequest.wrap(buildAwsValue())
}
object CreateEventActionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dataexchange.model.CreateEventActionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dataexchange.model.CreateEventActionRequest =
      zio.aws.dataexchange.model
        .CreateEventActionRequest(action.asEditable, event.asEditable)
    def action: zio.aws.dataexchange.model.Action.ReadOnly
    def event: zio.aws.dataexchange.model.Event.ReadOnly
    def getAction
        : ZIO[Any, Nothing, zio.aws.dataexchange.model.Action.ReadOnly] =
      ZIO.succeed(action)
    def getEvent: ZIO[Any, Nothing, zio.aws.dataexchange.model.Event.ReadOnly] =
      ZIO.succeed(event)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dataexchange.model.CreateEventActionRequest
  ) extends zio.aws.dataexchange.model.CreateEventActionRequest.ReadOnly {
    override val action: zio.aws.dataexchange.model.Action.ReadOnly =
      zio.aws.dataexchange.model.Action.wrap(impl.action())
    override val event: zio.aws.dataexchange.model.Event.ReadOnly =
      zio.aws.dataexchange.model.Event.wrap(impl.event())
  }
  def wrap(
      impl: software.amazon.awssdk.services.dataexchange.model.CreateEventActionRequest
  ): zio.aws.dataexchange.model.CreateEventActionRequest.ReadOnly = new Wrapper(
    impl
  )
}
