package zio.aws.dataexchange.model
import zio.aws.dataexchange.model.primitives.__string
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class S3DataAccessAssetSourceEntry(
    bucket: __string,
    keyPrefixes: Optional[Iterable[__string]] = Optional.Absent,
    keys: Optional[Iterable[__string]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dataexchange.model.S3DataAccessAssetSourceEntry = {
    import S3DataAccessAssetSourceEntry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dataexchange.model.S3DataAccessAssetSourceEntry
      .builder()
      .bucket(bucket: java.lang.String)
      .optionallyWith(
        keyPrefixes.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.keyPrefixes)
      .optionallyWith(
        keys.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.keys)
      .build()
  }
  def asReadOnly
      : zio.aws.dataexchange.model.S3DataAccessAssetSourceEntry.ReadOnly =
    zio.aws.dataexchange.model.S3DataAccessAssetSourceEntry
      .wrap(buildAwsValue())
}
object S3DataAccessAssetSourceEntry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dataexchange.model.S3DataAccessAssetSourceEntry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dataexchange.model.S3DataAccessAssetSourceEntry =
      zio.aws.dataexchange.model.S3DataAccessAssetSourceEntry(
        bucket,
        keyPrefixes.map(value => value),
        keys.map(value => value)
      )
    def bucket: __string
    def keyPrefixes: Optional[List[__string]]
    def keys: Optional[List[__string]]
    def getBucket: ZIO[Any, Nothing, __string] = ZIO.succeed(bucket)
    def getKeyPrefixes: ZIO[Any, AwsError, List[__string]] =
      AwsError.unwrapOptionField("keyPrefixes", keyPrefixes)
    def getKeys: ZIO[Any, AwsError, List[__string]] =
      AwsError.unwrapOptionField("keys", keys)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dataexchange.model.S3DataAccessAssetSourceEntry
  ) extends zio.aws.dataexchange.model.S3DataAccessAssetSourceEntry.ReadOnly {
    override val bucket: __string = impl.bucket(): __string
    override val keyPrefixes: Optional[List[__string]] = zio.aws.core.internal
      .optionalFromNullable(impl.keyPrefixes())
      .map(value =>
        value.asScala.map { item =>
          item: __string
        }.toList
      )
    override val keys: Optional[List[__string]] = zio.aws.core.internal
      .optionalFromNullable(impl.keys())
      .map(value =>
        value.asScala.map { item =>
          item: __string
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.dataexchange.model.S3DataAccessAssetSourceEntry
  ): zio.aws.dataexchange.model.S3DataAccessAssetSourceEntry.ReadOnly =
    new Wrapper(impl)
}
