package zio.aws.dataexchange.model
import zio.aws.dataexchange.model.primitives.__string
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class S3DataAccessAsset(
    bucket: __string,
    keyPrefixes: Optional[Iterable[__string]] = Optional.Absent,
    keys: Optional[Iterable[__string]] = Optional.Absent,
    s3AccessPointAlias: Optional[__string] = Optional.Absent,
    s3AccessPointArn: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dataexchange.model.S3DataAccessAsset = {
    import S3DataAccessAsset.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dataexchange.model.S3DataAccessAsset
      .builder()
      .bucket(bucket: java.lang.String)
      .optionallyWith(
        keyPrefixes.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.keyPrefixes)
      .optionallyWith(
        keys.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.keys)
      .optionallyWith(s3AccessPointAlias.map(value => value: java.lang.String))(
        _.s3AccessPointAlias
      )
      .optionallyWith(s3AccessPointArn.map(value => value: java.lang.String))(
        _.s3AccessPointArn
      )
      .build()
  }
  def asReadOnly: zio.aws.dataexchange.model.S3DataAccessAsset.ReadOnly =
    zio.aws.dataexchange.model.S3DataAccessAsset.wrap(buildAwsValue())
}
object S3DataAccessAsset {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dataexchange.model.S3DataAccessAsset
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dataexchange.model.S3DataAccessAsset =
      zio.aws.dataexchange.model.S3DataAccessAsset(
        bucket,
        keyPrefixes.map(value => value),
        keys.map(value => value),
        s3AccessPointAlias.map(value => value),
        s3AccessPointArn.map(value => value)
      )
    def bucket: __string
    def keyPrefixes: Optional[List[__string]]
    def keys: Optional[List[__string]]
    def s3AccessPointAlias: Optional[__string]
    def s3AccessPointArn: Optional[__string]
    def getBucket: ZIO[Any, Nothing, __string] = ZIO.succeed(bucket)
    def getKeyPrefixes: ZIO[Any, AwsError, List[__string]] =
      AwsError.unwrapOptionField("keyPrefixes", keyPrefixes)
    def getKeys: ZIO[Any, AwsError, List[__string]] =
      AwsError.unwrapOptionField("keys", keys)
    def getS3AccessPointAlias: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("s3AccessPointAlias", s3AccessPointAlias)
    def getS3AccessPointArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("s3AccessPointArn", s3AccessPointArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dataexchange.model.S3DataAccessAsset
  ) extends zio.aws.dataexchange.model.S3DataAccessAsset.ReadOnly {
    override val bucket: __string = impl.bucket(): __string
    override val keyPrefixes: Optional[List[__string]] = zio.aws.core.internal
      .optionalFromNullable(impl.keyPrefixes())
      .map(value =>
        value.asScala.map { item =>
          item: __string
        }.toList
      )
    override val keys: Optional[List[__string]] = zio.aws.core.internal
      .optionalFromNullable(impl.keys())
      .map(value =>
        value.asScala.map { item =>
          item: __string
        }.toList
      )
    override val s3AccessPointAlias: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.s3AccessPointAlias())
      .map(value => value: __string)
    override val s3AccessPointArn: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.s3AccessPointArn())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.dataexchange.model.S3DataAccessAsset
  ): zio.aws.dataexchange.model.S3DataAccessAsset.ReadOnly = new Wrapper(impl)
}
