package zio.aws.dataexchange.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.dataexchange.model.primitives.{MaxResults, __string}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListEventActionsRequest(
    eventSourceId: Optional[__string] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dataexchange.model.ListEventActionsRequest = {
    import ListEventActionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dataexchange.model.ListEventActionsRequest
      .builder()
      .optionallyWith(eventSourceId.map(value => value: java.lang.String))(
        _.eventSourceId
      )
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.dataexchange.model.ListEventActionsRequest.ReadOnly =
    zio.aws.dataexchange.model.ListEventActionsRequest.wrap(buildAwsValue())
}
object ListEventActionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dataexchange.model.ListEventActionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dataexchange.model.ListEventActionsRequest =
      zio.aws.dataexchange.model.ListEventActionsRequest(
        eventSourceId.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def eventSourceId: Optional[__string]
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[__string]
    def getEventSourceId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("eventSourceId", eventSourceId)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dataexchange.model.ListEventActionsRequest
  ) extends zio.aws.dataexchange.model.ListEventActionsRequest.ReadOnly {
    override val eventSourceId: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.eventSourceId())
      .map(value => value: __string)
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.dataexchange.model.primitives.MaxResults(value))
    override val nextToken: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.dataexchange.model.ListEventActionsRequest
  ): zio.aws.dataexchange.model.ListEventActionsRequest.ReadOnly = new Wrapper(
    impl
  )
}
