package zio.aws.dataexchange.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RequestDetails(
    exportAssetToSignedUrl: Optional[
      zio.aws.dataexchange.model.ExportAssetToSignedUrlRequestDetails
    ] = Optional.Absent,
    exportAssetsToS3: Optional[
      zio.aws.dataexchange.model.ExportAssetsToS3RequestDetails
    ] = Optional.Absent,
    exportRevisionsToS3: Optional[
      zio.aws.dataexchange.model.ExportRevisionsToS3RequestDetails
    ] = Optional.Absent,
    importAssetFromSignedUrl: Optional[
      zio.aws.dataexchange.model.ImportAssetFromSignedUrlRequestDetails
    ] = Optional.Absent,
    importAssetsFromS3: Optional[
      zio.aws.dataexchange.model.ImportAssetsFromS3RequestDetails
    ] = Optional.Absent,
    importAssetsFromRedshiftDataShares: Optional[
      zio.aws.dataexchange.model.ImportAssetsFromRedshiftDataSharesRequestDetails
    ] = Optional.Absent,
    importAssetFromApiGatewayApi: Optional[
      zio.aws.dataexchange.model.ImportAssetFromApiGatewayApiRequestDetails
    ] = Optional.Absent,
    createS3DataAccessFromS3Bucket: Optional[
      zio.aws.dataexchange.model.CreateS3DataAccessFromS3BucketRequestDetails
    ] = Optional.Absent,
    importAssetsFromLakeFormationTagPolicy: Optional[
      zio.aws.dataexchange.model.ImportAssetsFromLakeFormationTagPolicyRequestDetails
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dataexchange.model.RequestDetails = {
    import RequestDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dataexchange.model.RequestDetails
      .builder()
      .optionallyWith(
        exportAssetToSignedUrl.map(value => value.buildAwsValue())
      )(_.exportAssetToSignedUrl)
      .optionallyWith(exportAssetsToS3.map(value => value.buildAwsValue()))(
        _.exportAssetsToS3
      )
      .optionallyWith(exportRevisionsToS3.map(value => value.buildAwsValue()))(
        _.exportRevisionsToS3
      )
      .optionallyWith(
        importAssetFromSignedUrl.map(value => value.buildAwsValue())
      )(_.importAssetFromSignedUrl)
      .optionallyWith(importAssetsFromS3.map(value => value.buildAwsValue()))(
        _.importAssetsFromS3
      )
      .optionallyWith(
        importAssetsFromRedshiftDataShares.map(value => value.buildAwsValue())
      )(_.importAssetsFromRedshiftDataShares)
      .optionallyWith(
        importAssetFromApiGatewayApi.map(value => value.buildAwsValue())
      )(_.importAssetFromApiGatewayApi)
      .optionallyWith(
        createS3DataAccessFromS3Bucket.map(value => value.buildAwsValue())
      )(_.createS3DataAccessFromS3Bucket)
      .optionallyWith(
        importAssetsFromLakeFormationTagPolicy.map(value =>
          value.buildAwsValue()
        )
      )(_.importAssetsFromLakeFormationTagPolicy)
      .build()
  }
  def asReadOnly: zio.aws.dataexchange.model.RequestDetails.ReadOnly =
    zio.aws.dataexchange.model.RequestDetails.wrap(buildAwsValue())
}
object RequestDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dataexchange.model.RequestDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dataexchange.model.RequestDetails =
      zio.aws.dataexchange.model.RequestDetails(
        exportAssetToSignedUrl.map(value => value.asEditable),
        exportAssetsToS3.map(value => value.asEditable),
        exportRevisionsToS3.map(value => value.asEditable),
        importAssetFromSignedUrl.map(value => value.asEditable),
        importAssetsFromS3.map(value => value.asEditable),
        importAssetsFromRedshiftDataShares.map(value => value.asEditable),
        importAssetFromApiGatewayApi.map(value => value.asEditable),
        createS3DataAccessFromS3Bucket.map(value => value.asEditable),
        importAssetsFromLakeFormationTagPolicy.map(value => value.asEditable)
      )
    def exportAssetToSignedUrl: Optional[
      zio.aws.dataexchange.model.ExportAssetToSignedUrlRequestDetails.ReadOnly
    ]
    def exportAssetsToS3: Optional[
      zio.aws.dataexchange.model.ExportAssetsToS3RequestDetails.ReadOnly
    ]
    def exportRevisionsToS3: Optional[
      zio.aws.dataexchange.model.ExportRevisionsToS3RequestDetails.ReadOnly
    ]
    def importAssetFromSignedUrl: Optional[
      zio.aws.dataexchange.model.ImportAssetFromSignedUrlRequestDetails.ReadOnly
    ]
    def importAssetsFromS3: Optional[
      zio.aws.dataexchange.model.ImportAssetsFromS3RequestDetails.ReadOnly
    ]
    def importAssetsFromRedshiftDataShares: Optional[
      zio.aws.dataexchange.model.ImportAssetsFromRedshiftDataSharesRequestDetails.ReadOnly
    ]
    def importAssetFromApiGatewayApi: Optional[
      zio.aws.dataexchange.model.ImportAssetFromApiGatewayApiRequestDetails.ReadOnly
    ]
    def createS3DataAccessFromS3Bucket: Optional[
      zio.aws.dataexchange.model.CreateS3DataAccessFromS3BucketRequestDetails.ReadOnly
    ]
    def importAssetsFromLakeFormationTagPolicy: Optional[
      zio.aws.dataexchange.model.ImportAssetsFromLakeFormationTagPolicyRequestDetails.ReadOnly
    ]
    def getExportAssetToSignedUrl: ZIO[
      Any,
      AwsError,
      zio.aws.dataexchange.model.ExportAssetToSignedUrlRequestDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "exportAssetToSignedUrl",
      exportAssetToSignedUrl
    )
    def getExportAssetsToS3: ZIO[
      Any,
      AwsError,
      zio.aws.dataexchange.model.ExportAssetsToS3RequestDetails.ReadOnly
    ] = AwsError.unwrapOptionField("exportAssetsToS3", exportAssetsToS3)
    def getExportRevisionsToS3: ZIO[
      Any,
      AwsError,
      zio.aws.dataexchange.model.ExportRevisionsToS3RequestDetails.ReadOnly
    ] = AwsError.unwrapOptionField("exportRevisionsToS3", exportRevisionsToS3)
    def getImportAssetFromSignedUrl: ZIO[
      Any,
      AwsError,
      zio.aws.dataexchange.model.ImportAssetFromSignedUrlRequestDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "importAssetFromSignedUrl",
      importAssetFromSignedUrl
    )
    def getImportAssetsFromS3: ZIO[
      Any,
      AwsError,
      zio.aws.dataexchange.model.ImportAssetsFromS3RequestDetails.ReadOnly
    ] = AwsError.unwrapOptionField("importAssetsFromS3", importAssetsFromS3)
    def getImportAssetsFromRedshiftDataShares: ZIO[
      Any,
      AwsError,
      zio.aws.dataexchange.model.ImportAssetsFromRedshiftDataSharesRequestDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "importAssetsFromRedshiftDataShares",
      importAssetsFromRedshiftDataShares
    )
    def getImportAssetFromApiGatewayApi: ZIO[
      Any,
      AwsError,
      zio.aws.dataexchange.model.ImportAssetFromApiGatewayApiRequestDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "importAssetFromApiGatewayApi",
      importAssetFromApiGatewayApi
    )
    def getCreateS3DataAccessFromS3Bucket: ZIO[
      Any,
      AwsError,
      zio.aws.dataexchange.model.CreateS3DataAccessFromS3BucketRequestDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "createS3DataAccessFromS3Bucket",
      createS3DataAccessFromS3Bucket
    )
    def getImportAssetsFromLakeFormationTagPolicy: ZIO[
      Any,
      AwsError,
      zio.aws.dataexchange.model.ImportAssetsFromLakeFormationTagPolicyRequestDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "importAssetsFromLakeFormationTagPolicy",
      importAssetsFromLakeFormationTagPolicy
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dataexchange.model.RequestDetails
  ) extends zio.aws.dataexchange.model.RequestDetails.ReadOnly {
    override val exportAssetToSignedUrl: Optional[
      zio.aws.dataexchange.model.ExportAssetToSignedUrlRequestDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.exportAssetToSignedUrl())
      .map(value =>
        zio.aws.dataexchange.model.ExportAssetToSignedUrlRequestDetails
          .wrap(value)
      )
    override val exportAssetsToS3: Optional[
      zio.aws.dataexchange.model.ExportAssetsToS3RequestDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.exportAssetsToS3())
      .map(value =>
        zio.aws.dataexchange.model.ExportAssetsToS3RequestDetails.wrap(value)
      )
    override val exportRevisionsToS3: Optional[
      zio.aws.dataexchange.model.ExportRevisionsToS3RequestDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.exportRevisionsToS3())
      .map(value =>
        zio.aws.dataexchange.model.ExportRevisionsToS3RequestDetails.wrap(value)
      )
    override val importAssetFromSignedUrl: Optional[
      zio.aws.dataexchange.model.ImportAssetFromSignedUrlRequestDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.importAssetFromSignedUrl())
      .map(value =>
        zio.aws.dataexchange.model.ImportAssetFromSignedUrlRequestDetails
          .wrap(value)
      )
    override val importAssetsFromS3: Optional[
      zio.aws.dataexchange.model.ImportAssetsFromS3RequestDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.importAssetsFromS3())
      .map(value =>
        zio.aws.dataexchange.model.ImportAssetsFromS3RequestDetails.wrap(value)
      )
    override val importAssetsFromRedshiftDataShares: Optional[
      zio.aws.dataexchange.model.ImportAssetsFromRedshiftDataSharesRequestDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.importAssetsFromRedshiftDataShares())
      .map(value =>
        zio.aws.dataexchange.model.ImportAssetsFromRedshiftDataSharesRequestDetails
          .wrap(value)
      )
    override val importAssetFromApiGatewayApi: Optional[
      zio.aws.dataexchange.model.ImportAssetFromApiGatewayApiRequestDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.importAssetFromApiGatewayApi())
      .map(value =>
        zio.aws.dataexchange.model.ImportAssetFromApiGatewayApiRequestDetails
          .wrap(value)
      )
    override val createS3DataAccessFromS3Bucket: Optional[
      zio.aws.dataexchange.model.CreateS3DataAccessFromS3BucketRequestDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.createS3DataAccessFromS3Bucket())
      .map(value =>
        zio.aws.dataexchange.model.CreateS3DataAccessFromS3BucketRequestDetails
          .wrap(value)
      )
    override val importAssetsFromLakeFormationTagPolicy: Optional[
      zio.aws.dataexchange.model.ImportAssetsFromLakeFormationTagPolicyRequestDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.importAssetsFromLakeFormationTagPolicy())
      .map(value =>
        zio.aws.dataexchange.model.ImportAssetsFromLakeFormationTagPolicyRequestDetails
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.dataexchange.model.RequestDetails
  ): zio.aws.dataexchange.model.RequestDetails.ReadOnly = new Wrapper(impl)
}
