package zio.aws.dataexchange.model
import zio.aws.dataexchange.model.primitives.RoleArn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class LakeFormationDataPermissionAsset(
    lakeFormationDataPermissionDetails: zio.aws.dataexchange.model.LakeFormationDataPermissionDetails,
    lakeFormationDataPermissionType: zio.aws.dataexchange.model.LakeFormationDataPermissionType,
    permissions: Iterable[zio.aws.dataexchange.model.LFPermission],
    roleArn: Optional[RoleArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dataexchange.model.LakeFormationDataPermissionAsset = {
    import LakeFormationDataPermissionAsset.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dataexchange.model.LakeFormationDataPermissionAsset
      .builder()
      .lakeFormationDataPermissionDetails(
        lakeFormationDataPermissionDetails.buildAwsValue()
      )
      .lakeFormationDataPermissionType(lakeFormationDataPermissionType.unwrap)
      .permissionsWithStrings(permissions.map { item =>
        item.unwrap.toString
      }.asJavaCollection)
      .optionallyWith(
        roleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .build()
  }
  def asReadOnly
      : zio.aws.dataexchange.model.LakeFormationDataPermissionAsset.ReadOnly =
    zio.aws.dataexchange.model.LakeFormationDataPermissionAsset
      .wrap(buildAwsValue())
}
object LakeFormationDataPermissionAsset {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dataexchange.model.LakeFormationDataPermissionAsset
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.dataexchange.model.LakeFormationDataPermissionAsset =
      zio.aws.dataexchange.model.LakeFormationDataPermissionAsset(
        lakeFormationDataPermissionDetails.asEditable,
        lakeFormationDataPermissionType,
        permissions,
        roleArn.map(value => value)
      )
    def lakeFormationDataPermissionDetails
        : zio.aws.dataexchange.model.LakeFormationDataPermissionDetails.ReadOnly
    def lakeFormationDataPermissionType
        : zio.aws.dataexchange.model.LakeFormationDataPermissionType
    def permissions: List[zio.aws.dataexchange.model.LFPermission]
    def roleArn: Optional[RoleArn]
    def getLakeFormationDataPermissionDetails: ZIO[
      Any,
      Nothing,
      zio.aws.dataexchange.model.LakeFormationDataPermissionDetails.ReadOnly
    ] = ZIO.succeed(lakeFormationDataPermissionDetails)
    def getLakeFormationDataPermissionType: ZIO[
      Any,
      Nothing,
      zio.aws.dataexchange.model.LakeFormationDataPermissionType
    ] = ZIO.succeed(lakeFormationDataPermissionType)
    def getPermissions
        : ZIO[Any, Nothing, List[zio.aws.dataexchange.model.LFPermission]] =
      ZIO.succeed(permissions)
    def getRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dataexchange.model.LakeFormationDataPermissionAsset
  ) extends zio.aws.dataexchange.model.LakeFormationDataPermissionAsset.ReadOnly {
    override val lakeFormationDataPermissionDetails
        : zio.aws.dataexchange.model.LakeFormationDataPermissionDetails.ReadOnly =
      zio.aws.dataexchange.model.LakeFormationDataPermissionDetails
        .wrap(impl.lakeFormationDataPermissionDetails())
    override val lakeFormationDataPermissionType
        : zio.aws.dataexchange.model.LakeFormationDataPermissionType =
      zio.aws.dataexchange.model.LakeFormationDataPermissionType
        .wrap(impl.lakeFormationDataPermissionType())
    override val permissions: List[zio.aws.dataexchange.model.LFPermission] =
      impl
        .permissions()
        .asScala
        .map { item =>
          zio.aws.dataexchange.model.LFPermission.wrap(item)
        }
        .toList
    override val roleArn: Optional[RoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.roleArn())
      .map(value => zio.aws.dataexchange.model.primitives.RoleArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dataexchange.model.LakeFormationDataPermissionAsset
  ): zio.aws.dataexchange.model.LakeFormationDataPermissionAsset.ReadOnly =
    new Wrapper(impl)
}
