package zio.aws.dataexchange.model
import zio.aws.dataexchange.model.primitives.AwsAccountId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class LFTagPolicyDetails(
    catalogId: AwsAccountId,
    resourceType: zio.aws.dataexchange.model.LFResourceType,
    resourceDetails: zio.aws.dataexchange.model.LFResourceDetails
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dataexchange.model.LFTagPolicyDetails = {
    import LFTagPolicyDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dataexchange.model.LFTagPolicyDetails
      .builder()
      .catalogId(AwsAccountId.unwrap(catalogId): java.lang.String)
      .resourceType(resourceType.unwrap)
      .resourceDetails(resourceDetails.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.dataexchange.model.LFTagPolicyDetails.ReadOnly =
    zio.aws.dataexchange.model.LFTagPolicyDetails.wrap(buildAwsValue())
}
object LFTagPolicyDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dataexchange.model.LFTagPolicyDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dataexchange.model.LFTagPolicyDetails =
      zio.aws.dataexchange.model
        .LFTagPolicyDetails(catalogId, resourceType, resourceDetails.asEditable)
    def catalogId: AwsAccountId
    def resourceType: zio.aws.dataexchange.model.LFResourceType
    def resourceDetails: zio.aws.dataexchange.model.LFResourceDetails.ReadOnly
    def getCatalogId: ZIO[Any, Nothing, AwsAccountId] = ZIO.succeed(catalogId)
    def getResourceType
        : ZIO[Any, Nothing, zio.aws.dataexchange.model.LFResourceType] =
      ZIO.succeed(resourceType)
    def getResourceDetails: ZIO[
      Any,
      Nothing,
      zio.aws.dataexchange.model.LFResourceDetails.ReadOnly
    ] = ZIO.succeed(resourceDetails)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dataexchange.model.LFTagPolicyDetails
  ) extends zio.aws.dataexchange.model.LFTagPolicyDetails.ReadOnly {
    override val catalogId: AwsAccountId =
      zio.aws.dataexchange.model.primitives.AwsAccountId(impl.catalogId())
    override val resourceType: zio.aws.dataexchange.model.LFResourceType =
      zio.aws.dataexchange.model.LFResourceType.wrap(impl.resourceType())
    override val resourceDetails
        : zio.aws.dataexchange.model.LFResourceDetails.ReadOnly =
      zio.aws.dataexchange.model.LFResourceDetails.wrap(impl.resourceDetails())
  }
  def wrap(
      impl: software.amazon.awssdk.services.dataexchange.model.LFTagPolicyDetails
  ): zio.aws.dataexchange.model.LFTagPolicyDetails.ReadOnly = new Wrapper(impl)
}
