package zio.aws.dataexchange.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DatabaseLFTagPolicy(
    expression: Iterable[zio.aws.dataexchange.model.LFTag]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dataexchange.model.DatabaseLFTagPolicy = {
    import DatabaseLFTagPolicy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dataexchange.model.DatabaseLFTagPolicy
      .builder()
      .expression(expression.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.dataexchange.model.DatabaseLFTagPolicy.ReadOnly =
    zio.aws.dataexchange.model.DatabaseLFTagPolicy.wrap(buildAwsValue())
}
object DatabaseLFTagPolicy {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dataexchange.model.DatabaseLFTagPolicy
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dataexchange.model.DatabaseLFTagPolicy =
      zio.aws.dataexchange.model.DatabaseLFTagPolicy(expression.map { item =>
        item.asEditable
      })
    def expression: List[zio.aws.dataexchange.model.LFTag.ReadOnly]
    def getExpression
        : ZIO[Any, Nothing, List[zio.aws.dataexchange.model.LFTag.ReadOnly]] =
      ZIO.succeed(expression)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dataexchange.model.DatabaseLFTagPolicy
  ) extends zio.aws.dataexchange.model.DatabaseLFTagPolicy.ReadOnly {
    override val expression: List[zio.aws.dataexchange.model.LFTag.ReadOnly] =
      impl
        .expression()
        .asScala
        .map { item =>
          zio.aws.dataexchange.model.LFTag.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.dataexchange.model.DatabaseLFTagPolicy
  ): zio.aws.dataexchange.model.DatabaseLFTagPolicy.ReadOnly = new Wrapper(impl)
}
