package zio.aws.dataexchange.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AutoExportRevisionToS3RequestDetails(
    encryption: Optional[
      zio.aws.dataexchange.model.ExportServerSideEncryption
    ] = Optional.Absent,
    revisionDestination: zio.aws.dataexchange.model.AutoExportRevisionDestinationEntry
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dataexchange.model.AutoExportRevisionToS3RequestDetails = {
    import AutoExportRevisionToS3RequestDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dataexchange.model.AutoExportRevisionToS3RequestDetails
      .builder()
      .optionallyWith(encryption.map(value => value.buildAwsValue()))(
        _.encryption
      )
      .revisionDestination(revisionDestination.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.dataexchange.model.AutoExportRevisionToS3RequestDetails.ReadOnly =
    zio.aws.dataexchange.model.AutoExportRevisionToS3RequestDetails
      .wrap(buildAwsValue())
}
object AutoExportRevisionToS3RequestDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dataexchange.model.AutoExportRevisionToS3RequestDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.dataexchange.model.AutoExportRevisionToS3RequestDetails =
      zio.aws.dataexchange.model.AutoExportRevisionToS3RequestDetails(
        encryption.map(value => value.asEditable),
        revisionDestination.asEditable
      )
    def encryption: Optional[
      zio.aws.dataexchange.model.ExportServerSideEncryption.ReadOnly
    ]
    def revisionDestination
        : zio.aws.dataexchange.model.AutoExportRevisionDestinationEntry.ReadOnly
    def getEncryption: ZIO[
      Any,
      AwsError,
      zio.aws.dataexchange.model.ExportServerSideEncryption.ReadOnly
    ] = AwsError.unwrapOptionField("encryption", encryption)
    def getRevisionDestination: ZIO[
      Any,
      Nothing,
      zio.aws.dataexchange.model.AutoExportRevisionDestinationEntry.ReadOnly
    ] = ZIO.succeed(revisionDestination)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dataexchange.model.AutoExportRevisionToS3RequestDetails
  ) extends zio.aws.dataexchange.model.AutoExportRevisionToS3RequestDetails.ReadOnly {
    override val encryption: Optional[
      zio.aws.dataexchange.model.ExportServerSideEncryption.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.encryption())
      .map(value =>
        zio.aws.dataexchange.model.ExportServerSideEncryption.wrap(value)
      )
    override val revisionDestination
        : zio.aws.dataexchange.model.AutoExportRevisionDestinationEntry.ReadOnly =
      zio.aws.dataexchange.model.AutoExportRevisionDestinationEntry
        .wrap(impl.revisionDestination())
  }
  def wrap(
      impl: software.amazon.awssdk.services.dataexchange.model.AutoExportRevisionToS3RequestDetails
  ): zio.aws.dataexchange.model.AutoExportRevisionToS3RequestDetails.ReadOnly =
    new Wrapper(impl)
}
