package zio.aws.dataexchange.model
import zio.aws.dataexchange.model.primitives.{Id, __string}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RevisionDestinationEntry(
    bucket: __string,
    keyPattern: Optional[__string] = Optional.Absent,
    revisionId: Id
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dataexchange.model.RevisionDestinationEntry = {
    import RevisionDestinationEntry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dataexchange.model.RevisionDestinationEntry
      .builder()
      .bucket(bucket: java.lang.String)
      .optionallyWith(keyPattern.map(value => value: java.lang.String))(
        _.keyPattern
      )
      .revisionId(Id.unwrap(revisionId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.dataexchange.model.RevisionDestinationEntry.ReadOnly =
    zio.aws.dataexchange.model.RevisionDestinationEntry.wrap(buildAwsValue())
}
object RevisionDestinationEntry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dataexchange.model.RevisionDestinationEntry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dataexchange.model.RevisionDestinationEntry =
      zio.aws.dataexchange.model.RevisionDestinationEntry(
        bucket,
        keyPattern.map(value => value),
        revisionId
      )
    def bucket: __string
    def keyPattern: Optional[__string]
    def revisionId: Id
    def getBucket: ZIO[Any, Nothing, __string] = ZIO.succeed(bucket)
    def getKeyPattern: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("keyPattern", keyPattern)
    def getRevisionId: ZIO[Any, Nothing, Id] = ZIO.succeed(revisionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dataexchange.model.RevisionDestinationEntry
  ) extends zio.aws.dataexchange.model.RevisionDestinationEntry.ReadOnly {
    override val bucket: __string = impl.bucket(): __string
    override val keyPattern: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.keyPattern())
      .map(value => value: __string)
    override val revisionId: Id =
      zio.aws.dataexchange.model.primitives.Id(impl.revisionId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.dataexchange.model.RevisionDestinationEntry
  ): zio.aws.dataexchange.model.RevisionDestinationEntry.ReadOnly = new Wrapper(
    impl
  )
}
