package zio.aws.dataexchange.model
import zio.aws.dataexchange.model.primitives.Id
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ExportAssetToSignedUrlRequestDetails(
    assetId: Id,
    dataSetId: Id,
    revisionId: Id
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dataexchange.model.ExportAssetToSignedUrlRequestDetails = {
    import ExportAssetToSignedUrlRequestDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dataexchange.model.ExportAssetToSignedUrlRequestDetails
      .builder()
      .assetId(Id.unwrap(assetId): java.lang.String)
      .dataSetId(Id.unwrap(dataSetId): java.lang.String)
      .revisionId(Id.unwrap(revisionId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.dataexchange.model.ExportAssetToSignedUrlRequestDetails.ReadOnly =
    zio.aws.dataexchange.model.ExportAssetToSignedUrlRequestDetails
      .wrap(buildAwsValue())
}
object ExportAssetToSignedUrlRequestDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dataexchange.model.ExportAssetToSignedUrlRequestDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.dataexchange.model.ExportAssetToSignedUrlRequestDetails =
      zio.aws.dataexchange.model
        .ExportAssetToSignedUrlRequestDetails(assetId, dataSetId, revisionId)
    def assetId: Id
    def dataSetId: Id
    def revisionId: Id
    def getAssetId: ZIO[Any, Nothing, Id] = ZIO.succeed(assetId)
    def getDataSetId: ZIO[Any, Nothing, Id] = ZIO.succeed(dataSetId)
    def getRevisionId: ZIO[Any, Nothing, Id] = ZIO.succeed(revisionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dataexchange.model.ExportAssetToSignedUrlRequestDetails
  ) extends zio.aws.dataexchange.model.ExportAssetToSignedUrlRequestDetails.ReadOnly {
    override val assetId: Id =
      zio.aws.dataexchange.model.primitives.Id(impl.assetId())
    override val dataSetId: Id =
      zio.aws.dataexchange.model.primitives.Id(impl.dataSetId())
    override val revisionId: Id =
      zio.aws.dataexchange.model.primitives.Id(impl.revisionId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.dataexchange.model.ExportAssetToSignedUrlRequestDetails
  ): zio.aws.dataexchange.model.ExportAssetToSignedUrlRequestDetails.ReadOnly =
    new Wrapper(impl)
}
