package zio.aws.dataexchange.model
import zio.aws.dataexchange.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListJobsResponse(
    jobs: Optional[Iterable[zio.aws.dataexchange.model.JobEntry]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dataexchange.model.ListJobsResponse = {
    import ListJobsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dataexchange.model.ListJobsResponse
      .builder()
      .optionallyWith(
        jobs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.jobs)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.dataexchange.model.ListJobsResponse.ReadOnly =
    zio.aws.dataexchange.model.ListJobsResponse.wrap(buildAwsValue())
}
object ListJobsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dataexchange.model.ListJobsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dataexchange.model.ListJobsResponse =
      zio.aws.dataexchange.model.ListJobsResponse(
        jobs.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def jobs: Optional[List[zio.aws.dataexchange.model.JobEntry.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getJobs: ZIO[Any, AwsError, List[
      zio.aws.dataexchange.model.JobEntry.ReadOnly
    ]] = AwsError.unwrapOptionField("jobs", jobs)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dataexchange.model.ListJobsResponse
  ) extends zio.aws.dataexchange.model.ListJobsResponse.ReadOnly {
    override val jobs
        : Optional[List[zio.aws.dataexchange.model.JobEntry.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.jobs())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.dataexchange.model.JobEntry.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.dataexchange.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dataexchange.model.ListJobsResponse
  ): zio.aws.dataexchange.model.ListJobsResponse.ReadOnly = new Wrapper(impl)
}
