package zio.aws.dataexchange.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.dataexchange.model.primitives.{MaxResults, __string}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListDataSetRevisionsRequest(
    dataSetId: __string,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dataexchange.model.ListDataSetRevisionsRequest = {
    import ListDataSetRevisionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dataexchange.model.ListDataSetRevisionsRequest
      .builder()
      .dataSetId(dataSetId: java.lang.String)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.dataexchange.model.ListDataSetRevisionsRequest.ReadOnly =
    zio.aws.dataexchange.model.ListDataSetRevisionsRequest.wrap(buildAwsValue())
}
object ListDataSetRevisionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dataexchange.model.ListDataSetRevisionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dataexchange.model.ListDataSetRevisionsRequest =
      zio.aws.dataexchange.model.ListDataSetRevisionsRequest(
        dataSetId,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def dataSetId: __string
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[__string]
    def getDataSetId: ZIO[Any, Nothing, __string] = ZIO.succeed(dataSetId)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dataexchange.model.ListDataSetRevisionsRequest
  ) extends zio.aws.dataexchange.model.ListDataSetRevisionsRequest.ReadOnly {
    override val dataSetId: __string = impl.dataSetId(): __string
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.dataexchange.model.primitives.MaxResults(value))
    override val nextToken: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.dataexchange.model.ListDataSetRevisionsRequest
  ): zio.aws.dataexchange.model.ListDataSetRevisionsRequest.ReadOnly =
    new Wrapper(impl)
}
