package zio.aws.dataexchange.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.dataexchange.model.primitives.{Timestamp, __string, Id}
import scala.jdk.CollectionConverters._
final case class ExportAssetToSignedUrlResponseDetails(
    assetId: Id,
    dataSetId: Id,
    revisionId: Id,
    signedUrl: Optional[__string] = Optional.Absent,
    signedUrlExpiresAt: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dataexchange.model.ExportAssetToSignedUrlResponseDetails = {
    import ExportAssetToSignedUrlResponseDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dataexchange.model.ExportAssetToSignedUrlResponseDetails
      .builder()
      .assetId(Id.unwrap(assetId): java.lang.String)
      .dataSetId(Id.unwrap(dataSetId): java.lang.String)
      .revisionId(Id.unwrap(revisionId): java.lang.String)
      .optionallyWith(signedUrl.map(value => value: java.lang.String))(
        _.signedUrl
      )
      .optionallyWith(
        signedUrlExpiresAt.map(value => Timestamp.unwrap(value): Instant)
      )(_.signedUrlExpiresAt)
      .build()
  }
  def asReadOnly
      : zio.aws.dataexchange.model.ExportAssetToSignedUrlResponseDetails.ReadOnly =
    zio.aws.dataexchange.model.ExportAssetToSignedUrlResponseDetails
      .wrap(buildAwsValue())
}
object ExportAssetToSignedUrlResponseDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dataexchange.model.ExportAssetToSignedUrlResponseDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.dataexchange.model.ExportAssetToSignedUrlResponseDetails =
      zio.aws.dataexchange.model.ExportAssetToSignedUrlResponseDetails(
        assetId,
        dataSetId,
        revisionId,
        signedUrl.map(value => value),
        signedUrlExpiresAt.map(value => value)
      )
    def assetId: Id
    def dataSetId: Id
    def revisionId: Id
    def signedUrl: Optional[__string]
    def signedUrlExpiresAt: Optional[Timestamp]
    def getAssetId: ZIO[Any, Nothing, Id] = ZIO.succeed(assetId)
    def getDataSetId: ZIO[Any, Nothing, Id] = ZIO.succeed(dataSetId)
    def getRevisionId: ZIO[Any, Nothing, Id] = ZIO.succeed(revisionId)
    def getSignedUrl: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("signedUrl", signedUrl)
    def getSignedUrlExpiresAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("signedUrlExpiresAt", signedUrlExpiresAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dataexchange.model.ExportAssetToSignedUrlResponseDetails
  ) extends zio.aws.dataexchange.model.ExportAssetToSignedUrlResponseDetails.ReadOnly {
    override val assetId: Id =
      zio.aws.dataexchange.model.primitives.Id(impl.assetId())
    override val dataSetId: Id =
      zio.aws.dataexchange.model.primitives.Id(impl.dataSetId())
    override val revisionId: Id =
      zio.aws.dataexchange.model.primitives.Id(impl.revisionId())
    override val signedUrl: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.signedUrl())
      .map(value => value: __string)
    override val signedUrlExpiresAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.signedUrlExpiresAt())
      .map(value => zio.aws.dataexchange.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dataexchange.model.ExportAssetToSignedUrlResponseDetails
  ): zio.aws.dataexchange.model.ExportAssetToSignedUrlResponseDetails.ReadOnly =
    new Wrapper(impl)
}
