package zio.aws.dataexchange.model
import scala.jdk.CollectionConverters._
sealed trait JobErrorLimitName {
  def unwrap
      : software.amazon.awssdk.services.dataexchange.model.JobErrorLimitName
}
object JobErrorLimitName {
  def wrap(
      value: software.amazon.awssdk.services.dataexchange.model.JobErrorLimitName
  ): zio.aws.dataexchange.model.JobErrorLimitName = value match {
    case software.amazon.awssdk.services.dataexchange.model.JobErrorLimitName.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.dataexchange.model.JobErrorLimitName.ASSETS_PER_REVISION =>
      val r = `Assets per revision`
      r
    case software.amazon.awssdk.services.dataexchange.model.JobErrorLimitName.ASSET_SIZE_IN_GB =>
      val r = `Asset size in GB`
      r
    case software.amazon.awssdk.services.dataexchange.model.JobErrorLimitName.AMAZON_REDSHIFT_DATASHARE_ASSETS_PER_REVISION =>
      val r = `Amazon Redshift datashare assets per revision`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.dataexchange.model.JobErrorLimitName {
    override def unwrap
        : software.amazon.awssdk.services.dataexchange.model.JobErrorLimitName =
      software.amazon.awssdk.services.dataexchange.model.JobErrorLimitName.UNKNOWN_TO_SDK_VERSION
  }
  case object `Assets per revision`
      extends zio.aws.dataexchange.model.JobErrorLimitName {
    override def unwrap
        : software.amazon.awssdk.services.dataexchange.model.JobErrorLimitName =
      software.amazon.awssdk.services.dataexchange.model.JobErrorLimitName.ASSETS_PER_REVISION
  }
  case object `Asset size in GB`
      extends zio.aws.dataexchange.model.JobErrorLimitName {
    override def unwrap
        : software.amazon.awssdk.services.dataexchange.model.JobErrorLimitName =
      software.amazon.awssdk.services.dataexchange.model.JobErrorLimitName.ASSET_SIZE_IN_GB
  }
  case object `Amazon Redshift datashare assets per revision`
      extends zio.aws.dataexchange.model.JobErrorLimitName {
    override def unwrap
        : software.amazon.awssdk.services.dataexchange.model.JobErrorLimitName =
      software.amazon.awssdk.services.dataexchange.model.JobErrorLimitName.AMAZON_REDSHIFT_DATASHARE_ASSETS_PER_REVISION
  }
}
