package zio.aws.dataexchange.model
import zio.aws.dataexchange.model.primitives.{AssetName, __string}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class UpdateAssetRequest(
    assetId: __string,
    dataSetId: __string,
    name: AssetName,
    revisionId: __string
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dataexchange.model.UpdateAssetRequest = {
    import UpdateAssetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dataexchange.model.UpdateAssetRequest
      .builder()
      .assetId(assetId: java.lang.String)
      .dataSetId(dataSetId: java.lang.String)
      .name(AssetName.unwrap(name): java.lang.String)
      .revisionId(revisionId: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.dataexchange.model.UpdateAssetRequest.ReadOnly =
    zio.aws.dataexchange.model.UpdateAssetRequest.wrap(buildAwsValue())
}
object UpdateAssetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dataexchange.model.UpdateAssetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dataexchange.model.UpdateAssetRequest =
      zio.aws.dataexchange.model.UpdateAssetRequest(
        assetId,
        dataSetId,
        name,
        revisionId
      )
    def assetId: __string
    def dataSetId: __string
    def name: AssetName
    def revisionId: __string
    def getAssetId: ZIO[Any, Nothing, __string] = ZIO.succeed(assetId)
    def getDataSetId: ZIO[Any, Nothing, __string] = ZIO.succeed(dataSetId)
    def getName: ZIO[Any, Nothing, AssetName] = ZIO.succeed(name)
    def getRevisionId: ZIO[Any, Nothing, __string] = ZIO.succeed(revisionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dataexchange.model.UpdateAssetRequest
  ) extends zio.aws.dataexchange.model.UpdateAssetRequest.ReadOnly {
    override val assetId: __string = impl.assetId(): __string
    override val dataSetId: __string = impl.dataSetId(): __string
    override val name: AssetName =
      zio.aws.dataexchange.model.primitives.AssetName(impl.name())
    override val revisionId: __string = impl.revisionId(): __string
  }
  def wrap(
      impl: software.amazon.awssdk.services.dataexchange.model.UpdateAssetRequest
  ): zio.aws.dataexchange.model.UpdateAssetRequest.ReadOnly = new Wrapper(impl)
}
