package zio.aws.dataexchange.model
import scala.jdk.CollectionConverters._
sealed trait Type {
  def unwrap: software.amazon.awssdk.services.dataexchange.model.Type
}
object Type {
  def wrap(
      value: software.amazon.awssdk.services.dataexchange.model.Type
  ): zio.aws.dataexchange.model.Type = value match {
    case software.amazon.awssdk.services.dataexchange.model.Type.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.dataexchange.model.Type.IMPORT_ASSETS_FROM_S3 =>
      val r = IMPORT_ASSETS_FROM_S3
      r
    case software.amazon.awssdk.services.dataexchange.model.Type.IMPORT_ASSET_FROM_SIGNED_URL =>
      val r = IMPORT_ASSET_FROM_SIGNED_URL
      r
    case software.amazon.awssdk.services.dataexchange.model.Type.EXPORT_ASSETS_TO_S3 =>
      val r = EXPORT_ASSETS_TO_S3
      r
    case software.amazon.awssdk.services.dataexchange.model.Type.EXPORT_ASSET_TO_SIGNED_URL =>
      val r = EXPORT_ASSET_TO_SIGNED_URL
      r
    case software.amazon.awssdk.services.dataexchange.model.Type.EXPORT_REVISIONS_TO_S3 =>
      val r = EXPORT_REVISIONS_TO_S3
      r
    case software.amazon.awssdk.services.dataexchange.model.Type.IMPORT_ASSETS_FROM_REDSHIFT_DATA_SHARES =>
      val r = IMPORT_ASSETS_FROM_REDSHIFT_DATA_SHARES
      r
    case software.amazon.awssdk.services.dataexchange.model.Type.IMPORT_ASSET_FROM_API_GATEWAY_API =>
      val r = IMPORT_ASSET_FROM_API_GATEWAY_API
      r
  }
  case object unknownToSdkVersion extends zio.aws.dataexchange.model.Type {
    override def unwrap
        : software.amazon.awssdk.services.dataexchange.model.Type =
      software.amazon.awssdk.services.dataexchange.model.Type.UNKNOWN_TO_SDK_VERSION
  }
  case object IMPORT_ASSETS_FROM_S3 extends zio.aws.dataexchange.model.Type {
    override def unwrap
        : software.amazon.awssdk.services.dataexchange.model.Type =
      software.amazon.awssdk.services.dataexchange.model.Type.IMPORT_ASSETS_FROM_S3
  }
  case object IMPORT_ASSET_FROM_SIGNED_URL
      extends zio.aws.dataexchange.model.Type {
    override def unwrap
        : software.amazon.awssdk.services.dataexchange.model.Type =
      software.amazon.awssdk.services.dataexchange.model.Type.IMPORT_ASSET_FROM_SIGNED_URL
  }
  case object EXPORT_ASSETS_TO_S3 extends zio.aws.dataexchange.model.Type {
    override def unwrap
        : software.amazon.awssdk.services.dataexchange.model.Type =
      software.amazon.awssdk.services.dataexchange.model.Type.EXPORT_ASSETS_TO_S3
  }
  case object EXPORT_ASSET_TO_SIGNED_URL
      extends zio.aws.dataexchange.model.Type {
    override def unwrap
        : software.amazon.awssdk.services.dataexchange.model.Type =
      software.amazon.awssdk.services.dataexchange.model.Type.EXPORT_ASSET_TO_SIGNED_URL
  }
  case object EXPORT_REVISIONS_TO_S3 extends zio.aws.dataexchange.model.Type {
    override def unwrap
        : software.amazon.awssdk.services.dataexchange.model.Type =
      software.amazon.awssdk.services.dataexchange.model.Type.EXPORT_REVISIONS_TO_S3
  }
  case object IMPORT_ASSETS_FROM_REDSHIFT_DATA_SHARES
      extends zio.aws.dataexchange.model.Type {
    override def unwrap
        : software.amazon.awssdk.services.dataexchange.model.Type =
      software.amazon.awssdk.services.dataexchange.model.Type.IMPORT_ASSETS_FROM_REDSHIFT_DATA_SHARES
  }
  case object IMPORT_ASSET_FROM_API_GATEWAY_API
      extends zio.aws.dataexchange.model.Type {
    override def unwrap
        : software.amazon.awssdk.services.dataexchange.model.Type =
      software.amazon.awssdk.services.dataexchange.model.Type.IMPORT_ASSET_FROM_API_GATEWAY_API
  }
}
