package zio.aws.dataexchange.model
import zio.aws.dataexchange.model.primitives.{Id, Timestamp, Arn}
import zio.ZIO
import zio.aws.core.BuilderHelper
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class EventActionEntry(
    action: zio.aws.dataexchange.model.Action,
    arn: Arn,
    createdAt: Timestamp,
    event: zio.aws.dataexchange.model.Event,
    id: Id,
    updatedAt: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dataexchange.model.EventActionEntry = {
    import EventActionEntry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dataexchange.model.EventActionEntry
      .builder()
      .action(action.buildAwsValue())
      .arn(Arn.unwrap(arn): java.lang.String)
      .createdAt(Timestamp.unwrap(createdAt): Instant)
      .event(event.buildAwsValue())
      .id(Id.unwrap(id): java.lang.String)
      .updatedAt(Timestamp.unwrap(updatedAt): Instant)
      .build()
  }
  def asReadOnly: zio.aws.dataexchange.model.EventActionEntry.ReadOnly =
    zio.aws.dataexchange.model.EventActionEntry.wrap(buildAwsValue())
}
object EventActionEntry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dataexchange.model.EventActionEntry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dataexchange.model.EventActionEntry =
      zio.aws.dataexchange.model.EventActionEntry(
        action.asEditable,
        arn,
        createdAt,
        event.asEditable,
        id,
        updatedAt
      )
    def action: zio.aws.dataexchange.model.Action.ReadOnly
    def arn: Arn
    def createdAt: Timestamp
    def event: zio.aws.dataexchange.model.Event.ReadOnly
    def id: Id
    def updatedAt: Timestamp
    def getAction
        : ZIO[Any, Nothing, zio.aws.dataexchange.model.Action.ReadOnly] =
      ZIO.succeed(action)
    def getArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(arn)
    def getCreatedAt: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(createdAt)
    def getEvent: ZIO[Any, Nothing, zio.aws.dataexchange.model.Event.ReadOnly] =
      ZIO.succeed(event)
    def getId: ZIO[Any, Nothing, Id] = ZIO.succeed(id)
    def getUpdatedAt: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(updatedAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dataexchange.model.EventActionEntry
  ) extends zio.aws.dataexchange.model.EventActionEntry.ReadOnly {
    override val action: zio.aws.dataexchange.model.Action.ReadOnly =
      zio.aws.dataexchange.model.Action.wrap(impl.action())
    override val arn: Arn =
      zio.aws.dataexchange.model.primitives.Arn(impl.arn())
    override val createdAt: Timestamp =
      zio.aws.dataexchange.model.primitives.Timestamp(impl.createdAt())
    override val event: zio.aws.dataexchange.model.Event.ReadOnly =
      zio.aws.dataexchange.model.Event.wrap(impl.event())
    override val id: Id = zio.aws.dataexchange.model.primitives.Id(impl.id())
    override val updatedAt: Timestamp =
      zio.aws.dataexchange.model.primitives.Timestamp(impl.updatedAt())
  }
  def wrap(
      impl: software.amazon.awssdk.services.dataexchange.model.EventActionEntry
  ): zio.aws.dataexchange.model.EventActionEntry.ReadOnly = new Wrapper(impl)
}
