package zio.aws.dataexchange.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.dataexchange.model.primitives.{
  __string,
  Timestamp,
  Arn,
  Description,
  Name,
  Id
}
import scala.jdk.CollectionConverters._
final case class CreateDataSetResponse(
    arn: Optional[Arn] = Optional.Absent,
    assetType: Optional[zio.aws.dataexchange.model.AssetType] = Optional.Absent,
    createdAt: Optional[Timestamp] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    id: Optional[Id] = Optional.Absent,
    name: Optional[Name] = Optional.Absent,
    origin: Optional[zio.aws.dataexchange.model.Origin] = Optional.Absent,
    originDetails: Optional[zio.aws.dataexchange.model.OriginDetails] =
      Optional.Absent,
    sourceId: Optional[Id] = Optional.Absent,
    tags: Optional[Map[__string, __string]] = Optional.Absent,
    updatedAt: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dataexchange.model.CreateDataSetResponse = {
    import CreateDataSetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dataexchange.model.CreateDataSetResponse
      .builder()
      .optionallyWith(arn.map(value => Arn.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(assetType.map(value => value.unwrap))(_.assetType)
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(id.map(value => Id.unwrap(value): java.lang.String))(_.id)
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(origin.map(value => value.unwrap))(_.origin)
      .optionallyWith(originDetails.map(value => value.buildAwsValue()))(
        _.originDetails
      )
      .optionallyWith(
        sourceId.map(value => Id.unwrap(value): java.lang.String)
      )(_.sourceId)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(updatedAt.map(value => Timestamp.unwrap(value): Instant))(
        _.updatedAt
      )
      .build()
  }
  def asReadOnly: zio.aws.dataexchange.model.CreateDataSetResponse.ReadOnly =
    zio.aws.dataexchange.model.CreateDataSetResponse.wrap(buildAwsValue())
}
object CreateDataSetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dataexchange.model.CreateDataSetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dataexchange.model.CreateDataSetResponse =
      zio.aws.dataexchange.model.CreateDataSetResponse(
        arn.map(value => value),
        assetType.map(value => value),
        createdAt.map(value => value),
        description.map(value => value),
        id.map(value => value),
        name.map(value => value),
        origin.map(value => value),
        originDetails.map(value => value.asEditable),
        sourceId.map(value => value),
        tags.map(value => value),
        updatedAt.map(value => value)
      )
    def arn: Optional[Arn]
    def assetType: Optional[zio.aws.dataexchange.model.AssetType]
    def createdAt: Optional[Timestamp]
    def description: Optional[Description]
    def id: Optional[Id]
    def name: Optional[Name]
    def origin: Optional[zio.aws.dataexchange.model.Origin]
    def originDetails
        : Optional[zio.aws.dataexchange.model.OriginDetails.ReadOnly]
    def sourceId: Optional[Id]
    def tags: Optional[Map[__string, __string]]
    def updatedAt: Optional[Timestamp]
    def getArn: ZIO[Any, AwsError, Arn] = AwsError.unwrapOptionField("arn", arn)
    def getAssetType: ZIO[Any, AwsError, zio.aws.dataexchange.model.AssetType] =
      AwsError.unwrapOptionField("assetType", assetType)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getId: ZIO[Any, AwsError, Id] = AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getOrigin: ZIO[Any, AwsError, zio.aws.dataexchange.model.Origin] =
      AwsError.unwrapOptionField("origin", origin)
    def getOriginDetails: ZIO[
      Any,
      AwsError,
      zio.aws.dataexchange.model.OriginDetails.ReadOnly
    ] = AwsError.unwrapOptionField("originDetails", originDetails)
    def getSourceId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("sourceId", sourceId)
    def getTags: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("tags", tags)
    def getUpdatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("updatedAt", updatedAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dataexchange.model.CreateDataSetResponse
  ) extends zio.aws.dataexchange.model.CreateDataSetResponse.ReadOnly {
    override val arn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.dataexchange.model.primitives.Arn(value))
    override val assetType: Optional[zio.aws.dataexchange.model.AssetType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.assetType())
        .map(value => zio.aws.dataexchange.model.AssetType.wrap(value))
    override val createdAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.dataexchange.model.primitives.Timestamp(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.dataexchange.model.primitives.Description(value))
    override val id: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.dataexchange.model.primitives.Id(value))
    override val name: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.dataexchange.model.primitives.Name(value))
    override val origin: Optional[zio.aws.dataexchange.model.Origin] =
      zio.aws.core.internal
        .optionalFromNullable(impl.origin())
        .map(value => zio.aws.dataexchange.model.Origin.wrap(value))
    override val originDetails
        : Optional[zio.aws.dataexchange.model.OriginDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.originDetails())
        .map(value => zio.aws.dataexchange.model.OriginDetails.wrap(value))
    override val sourceId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceId())
      .map(value => zio.aws.dataexchange.model.primitives.Id(value))
    override val tags: Optional[Map[__string, __string]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: __string) -> (value: __string)
          })
          .toMap
      )
    override val updatedAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.updatedAt())
      .map(value => zio.aws.dataexchange.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dataexchange.model.CreateDataSetResponse
  ): zio.aws.dataexchange.model.CreateDataSetResponse.ReadOnly = new Wrapper(
    impl
  )
}
