package zio.aws.dataexchange.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AssetDetails(
    s3SnapshotAsset: Optional[zio.aws.dataexchange.model.S3SnapshotAsset] =
      Optional.Absent,
    redshiftDataShareAsset: Optional[
      zio.aws.dataexchange.model.RedshiftDataShareAsset
    ] = Optional.Absent,
    apiGatewayApiAsset: Optional[
      zio.aws.dataexchange.model.ApiGatewayApiAsset
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dataexchange.model.AssetDetails = {
    import AssetDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dataexchange.model.AssetDetails
      .builder()
      .optionallyWith(s3SnapshotAsset.map(value => value.buildAwsValue()))(
        _.s3SnapshotAsset
      )
      .optionallyWith(
        redshiftDataShareAsset.map(value => value.buildAwsValue())
      )(_.redshiftDataShareAsset)
      .optionallyWith(apiGatewayApiAsset.map(value => value.buildAwsValue()))(
        _.apiGatewayApiAsset
      )
      .build()
  }
  def asReadOnly: zio.aws.dataexchange.model.AssetDetails.ReadOnly =
    zio.aws.dataexchange.model.AssetDetails.wrap(buildAwsValue())
}
object AssetDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dataexchange.model.AssetDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dataexchange.model.AssetDetails =
      zio.aws.dataexchange.model.AssetDetails(
        s3SnapshotAsset.map(value => value.asEditable),
        redshiftDataShareAsset.map(value => value.asEditable),
        apiGatewayApiAsset.map(value => value.asEditable)
      )
    def s3SnapshotAsset
        : Optional[zio.aws.dataexchange.model.S3SnapshotAsset.ReadOnly]
    def redshiftDataShareAsset
        : Optional[zio.aws.dataexchange.model.RedshiftDataShareAsset.ReadOnly]
    def apiGatewayApiAsset
        : Optional[zio.aws.dataexchange.model.ApiGatewayApiAsset.ReadOnly]
    def getS3SnapshotAsset: ZIO[
      Any,
      AwsError,
      zio.aws.dataexchange.model.S3SnapshotAsset.ReadOnly
    ] = AwsError.unwrapOptionField("s3SnapshotAsset", s3SnapshotAsset)
    def getRedshiftDataShareAsset: ZIO[
      Any,
      AwsError,
      zio.aws.dataexchange.model.RedshiftDataShareAsset.ReadOnly
    ] = AwsError.unwrapOptionField(
      "redshiftDataShareAsset",
      redshiftDataShareAsset
    )
    def getApiGatewayApiAsset: ZIO[
      Any,
      AwsError,
      zio.aws.dataexchange.model.ApiGatewayApiAsset.ReadOnly
    ] = AwsError.unwrapOptionField("apiGatewayApiAsset", apiGatewayApiAsset)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dataexchange.model.AssetDetails
  ) extends zio.aws.dataexchange.model.AssetDetails.ReadOnly {
    override val s3SnapshotAsset
        : Optional[zio.aws.dataexchange.model.S3SnapshotAsset.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3SnapshotAsset())
        .map(value => zio.aws.dataexchange.model.S3SnapshotAsset.wrap(value))
    override val redshiftDataShareAsset
        : Optional[zio.aws.dataexchange.model.RedshiftDataShareAsset.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.redshiftDataShareAsset())
        .map(value =>
          zio.aws.dataexchange.model.RedshiftDataShareAsset.wrap(value)
        )
    override val apiGatewayApiAsset
        : Optional[zio.aws.dataexchange.model.ApiGatewayApiAsset.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.apiGatewayApiAsset())
        .map(value => zio.aws.dataexchange.model.ApiGatewayApiAsset.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dataexchange.model.AssetDetails
  ): zio.aws.dataexchange.model.AssetDetails.ReadOnly = new Wrapper(impl)
}
