package zio.aws.dataexchange.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.dataexchange.model.primitives.{
  Timestamp,
  __string,
  ApiDescription
}
import scala.jdk.CollectionConverters._
final case class ApiGatewayApiAsset(
    apiDescription: Optional[ApiDescription] = Optional.Absent,
    apiEndpoint: Optional[__string] = Optional.Absent,
    apiId: Optional[__string] = Optional.Absent,
    apiKey: Optional[__string] = Optional.Absent,
    apiName: Optional[__string] = Optional.Absent,
    apiSpecificationDownloadUrl: Optional[__string] = Optional.Absent,
    apiSpecificationDownloadUrlExpiresAt: Optional[Timestamp] = Optional.Absent,
    protocolType: Optional[zio.aws.dataexchange.model.ProtocolType] =
      Optional.Absent,
    stage: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dataexchange.model.ApiGatewayApiAsset = {
    import ApiGatewayApiAsset.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dataexchange.model.ApiGatewayApiAsset
      .builder()
      .optionallyWith(
        apiDescription.map(value =>
          ApiDescription.unwrap(value): java.lang.String
        )
      )(_.apiDescription)
      .optionallyWith(apiEndpoint.map(value => value: java.lang.String))(
        _.apiEndpoint
      )
      .optionallyWith(apiId.map(value => value: java.lang.String))(_.apiId)
      .optionallyWith(apiKey.map(value => value: java.lang.String))(_.apiKey)
      .optionallyWith(apiName.map(value => value: java.lang.String))(_.apiName)
      .optionallyWith(
        apiSpecificationDownloadUrl.map(value => value: java.lang.String)
      )(_.apiSpecificationDownloadUrl)
      .optionallyWith(
        apiSpecificationDownloadUrlExpiresAt.map(value =>
          Timestamp.unwrap(value): Instant
        )
      )(_.apiSpecificationDownloadUrlExpiresAt)
      .optionallyWith(protocolType.map(value => value.unwrap))(_.protocolType)
      .optionallyWith(stage.map(value => value: java.lang.String))(_.stage)
      .build()
  }
  def asReadOnly: zio.aws.dataexchange.model.ApiGatewayApiAsset.ReadOnly =
    zio.aws.dataexchange.model.ApiGatewayApiAsset.wrap(buildAwsValue())
}
object ApiGatewayApiAsset {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dataexchange.model.ApiGatewayApiAsset
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dataexchange.model.ApiGatewayApiAsset =
      zio.aws.dataexchange.model.ApiGatewayApiAsset(
        apiDescription.map(value => value),
        apiEndpoint.map(value => value),
        apiId.map(value => value),
        apiKey.map(value => value),
        apiName.map(value => value),
        apiSpecificationDownloadUrl.map(value => value),
        apiSpecificationDownloadUrlExpiresAt.map(value => value),
        protocolType.map(value => value),
        stage.map(value => value)
      )
    def apiDescription: Optional[ApiDescription]
    def apiEndpoint: Optional[__string]
    def apiId: Optional[__string]
    def apiKey: Optional[__string]
    def apiName: Optional[__string]
    def apiSpecificationDownloadUrl: Optional[__string]
    def apiSpecificationDownloadUrlExpiresAt: Optional[Timestamp]
    def protocolType: Optional[zio.aws.dataexchange.model.ProtocolType]
    def stage: Optional[__string]
    def getApiDescription: ZIO[Any, AwsError, ApiDescription] =
      AwsError.unwrapOptionField("apiDescription", apiDescription)
    def getApiEndpoint: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("apiEndpoint", apiEndpoint)
    def getApiId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("apiId", apiId)
    def getApiKey: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("apiKey", apiKey)
    def getApiName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("apiName", apiName)
    def getApiSpecificationDownloadUrl: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField(
        "apiSpecificationDownloadUrl",
        apiSpecificationDownloadUrl
      )
    def getApiSpecificationDownloadUrlExpiresAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField(
        "apiSpecificationDownloadUrlExpiresAt",
        apiSpecificationDownloadUrlExpiresAt
      )
    def getProtocolType
        : ZIO[Any, AwsError, zio.aws.dataexchange.model.ProtocolType] =
      AwsError.unwrapOptionField("protocolType", protocolType)
    def getStage: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("stage", stage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dataexchange.model.ApiGatewayApiAsset
  ) extends zio.aws.dataexchange.model.ApiGatewayApiAsset.ReadOnly {
    override val apiDescription: Optional[ApiDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.apiDescription())
        .map(value =>
          zio.aws.dataexchange.model.primitives.ApiDescription(value)
        )
    override val apiEndpoint: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.apiEndpoint())
      .map(value => value: __string)
    override val apiId: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.apiId())
      .map(value => value: __string)
    override val apiKey: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.apiKey())
      .map(value => value: __string)
    override val apiName: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.apiName())
      .map(value => value: __string)
    override val apiSpecificationDownloadUrl: Optional[__string] =
      zio.aws.core.internal
        .optionalFromNullable(impl.apiSpecificationDownloadUrl())
        .map(value => value: __string)
    override val apiSpecificationDownloadUrlExpiresAt: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.apiSpecificationDownloadUrlExpiresAt())
        .map(value => zio.aws.dataexchange.model.primitives.Timestamp(value))
    override val protocolType
        : Optional[zio.aws.dataexchange.model.ProtocolType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.protocolType())
        .map(value => zio.aws.dataexchange.model.ProtocolType.wrap(value))
    override val stage: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.stage())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.dataexchange.model.ApiGatewayApiAsset
  ): zio.aws.dataexchange.model.ApiGatewayApiAsset.ReadOnly = new Wrapper(impl)
}
