package zio.aws.dataexchange.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ResponseDetails(
    exportAssetToSignedUrl: Optional[
      zio.aws.dataexchange.model.ExportAssetToSignedUrlResponseDetails
    ] = Optional.Absent,
    exportAssetsToS3: Optional[
      zio.aws.dataexchange.model.ExportAssetsToS3ResponseDetails
    ] = Optional.Absent,
    exportRevisionsToS3: Optional[
      zio.aws.dataexchange.model.ExportRevisionsToS3ResponseDetails
    ] = Optional.Absent,
    importAssetFromSignedUrl: Optional[
      zio.aws.dataexchange.model.ImportAssetFromSignedUrlResponseDetails
    ] = Optional.Absent,
    importAssetsFromS3: Optional[
      zio.aws.dataexchange.model.ImportAssetsFromS3ResponseDetails
    ] = Optional.Absent,
    importAssetsFromRedshiftDataShares: Optional[
      zio.aws.dataexchange.model.ImportAssetsFromRedshiftDataSharesResponseDetails
    ] = Optional.Absent,
    importAssetFromApiGatewayApi: Optional[
      zio.aws.dataexchange.model.ImportAssetFromApiGatewayApiResponseDetails
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dataexchange.model.ResponseDetails = {
    import ResponseDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dataexchange.model.ResponseDetails
      .builder()
      .optionallyWith(
        exportAssetToSignedUrl.map(value => value.buildAwsValue())
      )(_.exportAssetToSignedUrl)
      .optionallyWith(exportAssetsToS3.map(value => value.buildAwsValue()))(
        _.exportAssetsToS3
      )
      .optionallyWith(exportRevisionsToS3.map(value => value.buildAwsValue()))(
        _.exportRevisionsToS3
      )
      .optionallyWith(
        importAssetFromSignedUrl.map(value => value.buildAwsValue())
      )(_.importAssetFromSignedUrl)
      .optionallyWith(importAssetsFromS3.map(value => value.buildAwsValue()))(
        _.importAssetsFromS3
      )
      .optionallyWith(
        importAssetsFromRedshiftDataShares.map(value => value.buildAwsValue())
      )(_.importAssetsFromRedshiftDataShares)
      .optionallyWith(
        importAssetFromApiGatewayApi.map(value => value.buildAwsValue())
      )(_.importAssetFromApiGatewayApi)
      .build()
  }
  def asReadOnly: zio.aws.dataexchange.model.ResponseDetails.ReadOnly =
    zio.aws.dataexchange.model.ResponseDetails.wrap(buildAwsValue())
}
object ResponseDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dataexchange.model.ResponseDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dataexchange.model.ResponseDetails =
      zio.aws.dataexchange.model.ResponseDetails(
        exportAssetToSignedUrl.map(value => value.asEditable),
        exportAssetsToS3.map(value => value.asEditable),
        exportRevisionsToS3.map(value => value.asEditable),
        importAssetFromSignedUrl.map(value => value.asEditable),
        importAssetsFromS3.map(value => value.asEditable),
        importAssetsFromRedshiftDataShares.map(value => value.asEditable),
        importAssetFromApiGatewayApi.map(value => value.asEditable)
      )
    def exportAssetToSignedUrl: Optional[
      zio.aws.dataexchange.model.ExportAssetToSignedUrlResponseDetails.ReadOnly
    ]
    def exportAssetsToS3: Optional[
      zio.aws.dataexchange.model.ExportAssetsToS3ResponseDetails.ReadOnly
    ]
    def exportRevisionsToS3: Optional[
      zio.aws.dataexchange.model.ExportRevisionsToS3ResponseDetails.ReadOnly
    ]
    def importAssetFromSignedUrl: Optional[
      zio.aws.dataexchange.model.ImportAssetFromSignedUrlResponseDetails.ReadOnly
    ]
    def importAssetsFromS3: Optional[
      zio.aws.dataexchange.model.ImportAssetsFromS3ResponseDetails.ReadOnly
    ]
    def importAssetsFromRedshiftDataShares: Optional[
      zio.aws.dataexchange.model.ImportAssetsFromRedshiftDataSharesResponseDetails.ReadOnly
    ]
    def importAssetFromApiGatewayApi: Optional[
      zio.aws.dataexchange.model.ImportAssetFromApiGatewayApiResponseDetails.ReadOnly
    ]
    def getExportAssetToSignedUrl: ZIO[
      Any,
      AwsError,
      zio.aws.dataexchange.model.ExportAssetToSignedUrlResponseDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "exportAssetToSignedUrl",
      exportAssetToSignedUrl
    )
    def getExportAssetsToS3: ZIO[
      Any,
      AwsError,
      zio.aws.dataexchange.model.ExportAssetsToS3ResponseDetails.ReadOnly
    ] = AwsError.unwrapOptionField("exportAssetsToS3", exportAssetsToS3)
    def getExportRevisionsToS3: ZIO[
      Any,
      AwsError,
      zio.aws.dataexchange.model.ExportRevisionsToS3ResponseDetails.ReadOnly
    ] = AwsError.unwrapOptionField("exportRevisionsToS3", exportRevisionsToS3)
    def getImportAssetFromSignedUrl: ZIO[
      Any,
      AwsError,
      zio.aws.dataexchange.model.ImportAssetFromSignedUrlResponseDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "importAssetFromSignedUrl",
      importAssetFromSignedUrl
    )
    def getImportAssetsFromS3: ZIO[
      Any,
      AwsError,
      zio.aws.dataexchange.model.ImportAssetsFromS3ResponseDetails.ReadOnly
    ] = AwsError.unwrapOptionField("importAssetsFromS3", importAssetsFromS3)
    def getImportAssetsFromRedshiftDataShares: ZIO[
      Any,
      AwsError,
      zio.aws.dataexchange.model.ImportAssetsFromRedshiftDataSharesResponseDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "importAssetsFromRedshiftDataShares",
      importAssetsFromRedshiftDataShares
    )
    def getImportAssetFromApiGatewayApi: ZIO[
      Any,
      AwsError,
      zio.aws.dataexchange.model.ImportAssetFromApiGatewayApiResponseDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "importAssetFromApiGatewayApi",
      importAssetFromApiGatewayApi
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dataexchange.model.ResponseDetails
  ) extends zio.aws.dataexchange.model.ResponseDetails.ReadOnly {
    override val exportAssetToSignedUrl: Optional[
      zio.aws.dataexchange.model.ExportAssetToSignedUrlResponseDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.exportAssetToSignedUrl())
      .map(value =>
        zio.aws.dataexchange.model.ExportAssetToSignedUrlResponseDetails
          .wrap(value)
      )
    override val exportAssetsToS3: Optional[
      zio.aws.dataexchange.model.ExportAssetsToS3ResponseDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.exportAssetsToS3())
      .map(value =>
        zio.aws.dataexchange.model.ExportAssetsToS3ResponseDetails.wrap(value)
      )
    override val exportRevisionsToS3: Optional[
      zio.aws.dataexchange.model.ExportRevisionsToS3ResponseDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.exportRevisionsToS3())
      .map(value =>
        zio.aws.dataexchange.model.ExportRevisionsToS3ResponseDetails
          .wrap(value)
      )
    override val importAssetFromSignedUrl: Optional[
      zio.aws.dataexchange.model.ImportAssetFromSignedUrlResponseDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.importAssetFromSignedUrl())
      .map(value =>
        zio.aws.dataexchange.model.ImportAssetFromSignedUrlResponseDetails
          .wrap(value)
      )
    override val importAssetsFromS3: Optional[
      zio.aws.dataexchange.model.ImportAssetsFromS3ResponseDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.importAssetsFromS3())
      .map(value =>
        zio.aws.dataexchange.model.ImportAssetsFromS3ResponseDetails.wrap(value)
      )
    override val importAssetsFromRedshiftDataShares: Optional[
      zio.aws.dataexchange.model.ImportAssetsFromRedshiftDataSharesResponseDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.importAssetsFromRedshiftDataShares())
      .map(value =>
        zio.aws.dataexchange.model.ImportAssetsFromRedshiftDataSharesResponseDetails
          .wrap(value)
      )
    override val importAssetFromApiGatewayApi: Optional[
      zio.aws.dataexchange.model.ImportAssetFromApiGatewayApiResponseDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.importAssetFromApiGatewayApi())
      .map(value =>
        zio.aws.dataexchange.model.ImportAssetFromApiGatewayApiResponseDetails
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.dataexchange.model.ResponseDetails
  ): zio.aws.dataexchange.model.ResponseDetails.ReadOnly = new Wrapper(impl)
}
