package zio.aws.dataexchange.model
import zio.aws.dataexchange.model.primitives.Id
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ExportAssetsToS3RequestDetails(
    assetDestinations: Iterable[
      zio.aws.dataexchange.model.AssetDestinationEntry
    ],
    dataSetId: Id,
    encryption: Optional[
      zio.aws.dataexchange.model.ExportServerSideEncryption
    ] = Optional.Absent,
    revisionId: Id
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dataexchange.model.ExportAssetsToS3RequestDetails = {
    import ExportAssetsToS3RequestDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dataexchange.model.ExportAssetsToS3RequestDetails
      .builder()
      .assetDestinations(assetDestinations.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .dataSetId(Id.unwrap(dataSetId): java.lang.String)
      .optionallyWith(encryption.map(value => value.buildAwsValue()))(
        _.encryption
      )
      .revisionId(Id.unwrap(revisionId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.dataexchange.model.ExportAssetsToS3RequestDetails.ReadOnly =
    zio.aws.dataexchange.model.ExportAssetsToS3RequestDetails
      .wrap(buildAwsValue())
}
object ExportAssetsToS3RequestDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dataexchange.model.ExportAssetsToS3RequestDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dataexchange.model.ExportAssetsToS3RequestDetails =
      zio.aws.dataexchange.model.ExportAssetsToS3RequestDetails(
        assetDestinations.map { item =>
          item.asEditable
        },
        dataSetId,
        encryption.map(value => value.asEditable),
        revisionId
      )
    def assetDestinations
        : List[zio.aws.dataexchange.model.AssetDestinationEntry.ReadOnly]
    def dataSetId: Id
    def encryption: Optional[
      zio.aws.dataexchange.model.ExportServerSideEncryption.ReadOnly
    ]
    def revisionId: Id
    def getAssetDestinations: ZIO[Any, Nothing, List[
      zio.aws.dataexchange.model.AssetDestinationEntry.ReadOnly
    ]] = ZIO.succeed(assetDestinations)
    def getDataSetId: ZIO[Any, Nothing, Id] = ZIO.succeed(dataSetId)
    def getEncryption: ZIO[
      Any,
      AwsError,
      zio.aws.dataexchange.model.ExportServerSideEncryption.ReadOnly
    ] = AwsError.unwrapOptionField("encryption", encryption)
    def getRevisionId: ZIO[Any, Nothing, Id] = ZIO.succeed(revisionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dataexchange.model.ExportAssetsToS3RequestDetails
  ) extends zio.aws.dataexchange.model.ExportAssetsToS3RequestDetails.ReadOnly {
    override val assetDestinations
        : List[zio.aws.dataexchange.model.AssetDestinationEntry.ReadOnly] = impl
      .assetDestinations()
      .asScala
      .map { item =>
        zio.aws.dataexchange.model.AssetDestinationEntry.wrap(item)
      }
      .toList
    override val dataSetId: Id =
      zio.aws.dataexchange.model.primitives.Id(impl.dataSetId())
    override val encryption: Optional[
      zio.aws.dataexchange.model.ExportServerSideEncryption.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.encryption())
      .map(value =>
        zio.aws.dataexchange.model.ExportServerSideEncryption.wrap(value)
      )
    override val revisionId: Id =
      zio.aws.dataexchange.model.primitives.Id(impl.revisionId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.dataexchange.model.ExportAssetsToS3RequestDetails
  ): zio.aws.dataexchange.model.ExportAssetsToS3RequestDetails.ReadOnly =
    new Wrapper(impl)
}
