package zio.aws.dataexchange.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.dataexchange.model.primitives.{__string, MaxResults}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListDataSetsRequest(
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[__string] = Optional.Absent,
    origin: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dataexchange.model.ListDataSetsRequest = {
    import ListDataSetsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dataexchange.model.ListDataSetsRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(origin.map(value => value: java.lang.String))(_.origin)
      .build()
  }
  def asReadOnly: zio.aws.dataexchange.model.ListDataSetsRequest.ReadOnly =
    zio.aws.dataexchange.model.ListDataSetsRequest.wrap(buildAwsValue())
}
object ListDataSetsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dataexchange.model.ListDataSetsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dataexchange.model.ListDataSetsRequest =
      zio.aws.dataexchange.model.ListDataSetsRequest(
        maxResults.map(value => value),
        nextToken.map(value => value),
        origin.map(value => value)
      )
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[__string]
    def origin: Optional[__string]
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getOrigin: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("origin", origin)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dataexchange.model.ListDataSetsRequest
  ) extends zio.aws.dataexchange.model.ListDataSetsRequest.ReadOnly {
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.dataexchange.model.primitives.MaxResults(value))
    override val nextToken: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: __string)
    override val origin: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.origin())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.dataexchange.model.ListDataSetsRequest
  ): zio.aws.dataexchange.model.ListDataSetsRequest.ReadOnly = new Wrapper(impl)
}
