package zio.aws.dataexchange.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.dataexchange.model.primitives.{
  __stringMin10Max512,
  __string,
  Timestamp,
  __boolean,
  Arn,
  __stringMin0Max16384,
  Id
}
import scala.jdk.CollectionConverters._
final case class GetRevisionResponse(
    arn: Optional[Arn] = Optional.Absent,
    comment: Optional[__stringMin0Max16384] = Optional.Absent,
    createdAt: Optional[Timestamp] = Optional.Absent,
    dataSetId: Optional[Id] = Optional.Absent,
    finalized: Optional[__boolean] = Optional.Absent,
    id: Optional[Id] = Optional.Absent,
    sourceId: Optional[Id] = Optional.Absent,
    tags: Optional[Map[__string, __string]] = Optional.Absent,
    updatedAt: Optional[Timestamp] = Optional.Absent,
    revocationComment: Optional[__stringMin10Max512] = Optional.Absent,
    revoked: Optional[__boolean] = Optional.Absent,
    revokedAt: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dataexchange.model.GetRevisionResponse = {
    import GetRevisionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dataexchange.model.GetRevisionResponse
      .builder()
      .optionallyWith(arn.map(value => Arn.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(comment.map(value => value: java.lang.String))(_.comment)
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(
        dataSetId.map(value => Id.unwrap(value): java.lang.String)
      )(_.dataSetId)
      .optionallyWith(finalized.map(value => value: java.lang.Boolean))(
        _.finalized
      )
      .optionallyWith(id.map(value => Id.unwrap(value): java.lang.String))(_.id)
      .optionallyWith(
        sourceId.map(value => Id.unwrap(value): java.lang.String)
      )(_.sourceId)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(updatedAt.map(value => Timestamp.unwrap(value): Instant))(
        _.updatedAt
      )
      .optionallyWith(revocationComment.map(value => value: java.lang.String))(
        _.revocationComment
      )
      .optionallyWith(revoked.map(value => value: java.lang.Boolean))(_.revoked)
      .optionallyWith(revokedAt.map(value => Timestamp.unwrap(value): Instant))(
        _.revokedAt
      )
      .build()
  }
  def asReadOnly: zio.aws.dataexchange.model.GetRevisionResponse.ReadOnly =
    zio.aws.dataexchange.model.GetRevisionResponse.wrap(buildAwsValue())
}
object GetRevisionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dataexchange.model.GetRevisionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dataexchange.model.GetRevisionResponse =
      zio.aws.dataexchange.model.GetRevisionResponse(
        arn.map(value => value),
        comment.map(value => value),
        createdAt.map(value => value),
        dataSetId.map(value => value),
        finalized.map(value => value),
        id.map(value => value),
        sourceId.map(value => value),
        tags.map(value => value),
        updatedAt.map(value => value),
        revocationComment.map(value => value),
        revoked.map(value => value),
        revokedAt.map(value => value)
      )
    def arn: Optional[Arn]
    def comment: Optional[__stringMin0Max16384]
    def createdAt: Optional[Timestamp]
    def dataSetId: Optional[Id]
    def finalized: Optional[__boolean]
    def id: Optional[Id]
    def sourceId: Optional[Id]
    def tags: Optional[Map[__string, __string]]
    def updatedAt: Optional[Timestamp]
    def revocationComment: Optional[__stringMin10Max512]
    def revoked: Optional[__boolean]
    def revokedAt: Optional[Timestamp]
    def getArn: ZIO[Any, AwsError, Arn] = AwsError.unwrapOptionField("arn", arn)
    def getComment: ZIO[Any, AwsError, __stringMin0Max16384] =
      AwsError.unwrapOptionField("comment", comment)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getDataSetId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("dataSetId", dataSetId)
    def getFinalized: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("finalized", finalized)
    def getId: ZIO[Any, AwsError, Id] = AwsError.unwrapOptionField("id", id)
    def getSourceId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("sourceId", sourceId)
    def getTags: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("tags", tags)
    def getUpdatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("updatedAt", updatedAt)
    def getRevocationComment: ZIO[Any, AwsError, __stringMin10Max512] =
      AwsError.unwrapOptionField("revocationComment", revocationComment)
    def getRevoked: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("revoked", revoked)
    def getRevokedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("revokedAt", revokedAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dataexchange.model.GetRevisionResponse
  ) extends zio.aws.dataexchange.model.GetRevisionResponse.ReadOnly {
    override val arn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.dataexchange.model.primitives.Arn(value))
    override val comment: Optional[__stringMin0Max16384] = zio.aws.core.internal
      .optionalFromNullable(impl.comment())
      .map(value => value: __stringMin0Max16384)
    override val createdAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.dataexchange.model.primitives.Timestamp(value))
    override val dataSetId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.dataSetId())
      .map(value => zio.aws.dataexchange.model.primitives.Id(value))
    override val finalized: Optional[__boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.finalized())
      .map(value => value: __boolean)
    override val id: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.dataexchange.model.primitives.Id(value))
    override val sourceId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceId())
      .map(value => zio.aws.dataexchange.model.primitives.Id(value))
    override val tags: Optional[Map[__string, __string]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: __string) -> (value: __string)
          })
          .toMap
      )
    override val updatedAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.updatedAt())
      .map(value => zio.aws.dataexchange.model.primitives.Timestamp(value))
    override val revocationComment: Optional[__stringMin10Max512] =
      zio.aws.core.internal
        .optionalFromNullable(impl.revocationComment())
        .map(value => value: __stringMin10Max512)
    override val revoked: Optional[__boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.revoked())
      .map(value => value: __boolean)
    override val revokedAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.revokedAt())
      .map(value => zio.aws.dataexchange.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dataexchange.model.GetRevisionResponse
  ): zio.aws.dataexchange.model.GetRevisionResponse.ReadOnly = new Wrapper(impl)
}
