package zio.aws.dataexchange.model
import zio.aws.dataexchange.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListEventActionsResponse(
    eventActions: Optional[
      Iterable[zio.aws.dataexchange.model.EventActionEntry]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dataexchange.model.ListEventActionsResponse = {
    import ListEventActionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dataexchange.model.ListEventActionsResponse
      .builder()
      .optionallyWith(
        eventActions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.eventActions)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.dataexchange.model.ListEventActionsResponse.ReadOnly =
    zio.aws.dataexchange.model.ListEventActionsResponse.wrap(buildAwsValue())
}
object ListEventActionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dataexchange.model.ListEventActionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dataexchange.model.ListEventActionsResponse =
      zio.aws.dataexchange.model.ListEventActionsResponse(
        eventActions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def eventActions
        : Optional[List[zio.aws.dataexchange.model.EventActionEntry.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getEventActions: ZIO[Any, AwsError, List[
      zio.aws.dataexchange.model.EventActionEntry.ReadOnly
    ]] = AwsError.unwrapOptionField("eventActions", eventActions)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dataexchange.model.ListEventActionsResponse
  ) extends zio.aws.dataexchange.model.ListEventActionsResponse.ReadOnly {
    override val eventActions
        : Optional[List[zio.aws.dataexchange.model.EventActionEntry.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.eventActions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.dataexchange.model.EventActionEntry.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.dataexchange.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dataexchange.model.ListEventActionsResponse
  ): zio.aws.dataexchange.model.ListEventActionsResponse.ReadOnly = new Wrapper(
    impl
  )
}
