package zio.aws.dataexchange.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.dataexchange.model.primitives.{Id, Timestamp, Arn}
import scala.jdk.CollectionConverters._
final case class GetEventActionResponse(
    action: Optional[zio.aws.dataexchange.model.Action] = Optional.Absent,
    arn: Optional[Arn] = Optional.Absent,
    createdAt: Optional[Timestamp] = Optional.Absent,
    event: Optional[zio.aws.dataexchange.model.Event] = Optional.Absent,
    id: Optional[Id] = Optional.Absent,
    updatedAt: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dataexchange.model.GetEventActionResponse = {
    import GetEventActionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dataexchange.model.GetEventActionResponse
      .builder()
      .optionallyWith(action.map(value => value.buildAwsValue()))(_.action)
      .optionallyWith(arn.map(value => Arn.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(event.map(value => value.buildAwsValue()))(_.event)
      .optionallyWith(id.map(value => Id.unwrap(value): java.lang.String))(_.id)
      .optionallyWith(updatedAt.map(value => Timestamp.unwrap(value): Instant))(
        _.updatedAt
      )
      .build()
  }
  def asReadOnly: zio.aws.dataexchange.model.GetEventActionResponse.ReadOnly =
    zio.aws.dataexchange.model.GetEventActionResponse.wrap(buildAwsValue())
}
object GetEventActionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dataexchange.model.GetEventActionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dataexchange.model.GetEventActionResponse =
      zio.aws.dataexchange.model.GetEventActionResponse(
        action.map(value => value.asEditable),
        arn.map(value => value),
        createdAt.map(value => value),
        event.map(value => value.asEditable),
        id.map(value => value),
        updatedAt.map(value => value)
      )
    def action: Optional[zio.aws.dataexchange.model.Action.ReadOnly]
    def arn: Optional[Arn]
    def createdAt: Optional[Timestamp]
    def event: Optional[zio.aws.dataexchange.model.Event.ReadOnly]
    def id: Optional[Id]
    def updatedAt: Optional[Timestamp]
    def getAction
        : ZIO[Any, AwsError, zio.aws.dataexchange.model.Action.ReadOnly] =
      AwsError.unwrapOptionField("action", action)
    def getArn: ZIO[Any, AwsError, Arn] = AwsError.unwrapOptionField("arn", arn)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getEvent
        : ZIO[Any, AwsError, zio.aws.dataexchange.model.Event.ReadOnly] =
      AwsError.unwrapOptionField("event", event)
    def getId: ZIO[Any, AwsError, Id] = AwsError.unwrapOptionField("id", id)
    def getUpdatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("updatedAt", updatedAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dataexchange.model.GetEventActionResponse
  ) extends zio.aws.dataexchange.model.GetEventActionResponse.ReadOnly {
    override val action: Optional[zio.aws.dataexchange.model.Action.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.action())
        .map(value => zio.aws.dataexchange.model.Action.wrap(value))
    override val arn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.dataexchange.model.primitives.Arn(value))
    override val createdAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.dataexchange.model.primitives.Timestamp(value))
    override val event: Optional[zio.aws.dataexchange.model.Event.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.event())
        .map(value => zio.aws.dataexchange.model.Event.wrap(value))
    override val id: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.dataexchange.model.primitives.Id(value))
    override val updatedAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.updatedAt())
      .map(value => zio.aws.dataexchange.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dataexchange.model.GetEventActionResponse
  ): zio.aws.dataexchange.model.GetEventActionResponse.ReadOnly = new Wrapper(
    impl
  )
}
