package zio.aws.dataexchange.model
import zio.aws.dataexchange.model.primitives.Id
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ImportAssetsFromS3ResponseDetails(
    assetSources: Iterable[zio.aws.dataexchange.model.AssetSourceEntry],
    dataSetId: Id,
    revisionId: Id
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dataexchange.model.ImportAssetsFromS3ResponseDetails = {
    import ImportAssetsFromS3ResponseDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dataexchange.model.ImportAssetsFromS3ResponseDetails
      .builder()
      .assetSources(assetSources.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .dataSetId(Id.unwrap(dataSetId): java.lang.String)
      .revisionId(Id.unwrap(revisionId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.dataexchange.model.ImportAssetsFromS3ResponseDetails.ReadOnly =
    zio.aws.dataexchange.model.ImportAssetsFromS3ResponseDetails
      .wrap(buildAwsValue())
}
object ImportAssetsFromS3ResponseDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dataexchange.model.ImportAssetsFromS3ResponseDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.dataexchange.model.ImportAssetsFromS3ResponseDetails =
      zio.aws.dataexchange.model.ImportAssetsFromS3ResponseDetails(
        assetSources.map { item =>
          item.asEditable
        },
        dataSetId,
        revisionId
      )
    def assetSources: List[zio.aws.dataexchange.model.AssetSourceEntry.ReadOnly]
    def dataSetId: Id
    def revisionId: Id
    def getAssetSources: ZIO[Any, Nothing, List[
      zio.aws.dataexchange.model.AssetSourceEntry.ReadOnly
    ]] = ZIO.succeed(assetSources)
    def getDataSetId: ZIO[Any, Nothing, Id] = ZIO.succeed(dataSetId)
    def getRevisionId: ZIO[Any, Nothing, Id] = ZIO.succeed(revisionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dataexchange.model.ImportAssetsFromS3ResponseDetails
  ) extends zio.aws.dataexchange.model.ImportAssetsFromS3ResponseDetails.ReadOnly {
    override val assetSources
        : List[zio.aws.dataexchange.model.AssetSourceEntry.ReadOnly] = impl
      .assetSources()
      .asScala
      .map { item =>
        zio.aws.dataexchange.model.AssetSourceEntry.wrap(item)
      }
      .toList
    override val dataSetId: Id =
      zio.aws.dataexchange.model.primitives.Id(impl.dataSetId())
    override val revisionId: Id =
      zio.aws.dataexchange.model.primitives.Id(impl.revisionId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.dataexchange.model.ImportAssetsFromS3ResponseDetails
  ): zio.aws.dataexchange.model.ImportAssetsFromS3ResponseDetails.ReadOnly =
    new Wrapper(impl)
}
