package zio.aws.dataexchange.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.dataexchange.model.primitives.{Id, Timestamp, Arn}
import scala.jdk.CollectionConverters._
final case class CreateJobResponse(
    arn: Optional[Arn] = Optional.Absent,
    createdAt: Optional[Timestamp] = Optional.Absent,
    details: Optional[zio.aws.dataexchange.model.ResponseDetails] =
      Optional.Absent,
    errors: Optional[Iterable[zio.aws.dataexchange.model.JobError]] =
      Optional.Absent,
    id: Optional[Id] = Optional.Absent,
    state: Optional[zio.aws.dataexchange.model.State] = Optional.Absent,
    `type`: Optional[zio.aws.dataexchange.model.Type] = Optional.Absent,
    updatedAt: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dataexchange.model.CreateJobResponse = {
    import CreateJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dataexchange.model.CreateJobResponse
      .builder()
      .optionallyWith(arn.map(value => Arn.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(details.map(value => value.buildAwsValue()))(_.details)
      .optionallyWith(
        errors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.errors)
      .optionallyWith(id.map(value => Id.unwrap(value): java.lang.String))(_.id)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(updatedAt.map(value => Timestamp.unwrap(value): Instant))(
        _.updatedAt
      )
      .build()
  }
  def asReadOnly: zio.aws.dataexchange.model.CreateJobResponse.ReadOnly =
    zio.aws.dataexchange.model.CreateJobResponse.wrap(buildAwsValue())
}
object CreateJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dataexchange.model.CreateJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dataexchange.model.CreateJobResponse =
      zio.aws.dataexchange.model.CreateJobResponse(
        arn.map(value => value),
        createdAt.map(value => value),
        details.map(value => value.asEditable),
        errors.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        id.map(value => value),
        state.map(value => value),
        `type`.map(value => value),
        updatedAt.map(value => value)
      )
    def arn: Optional[Arn]
    def createdAt: Optional[Timestamp]
    def details: Optional[zio.aws.dataexchange.model.ResponseDetails.ReadOnly]
    def errors: Optional[List[zio.aws.dataexchange.model.JobError.ReadOnly]]
    def id: Optional[Id]
    def state: Optional[zio.aws.dataexchange.model.State]
    def `type`: Optional[zio.aws.dataexchange.model.Type]
    def updatedAt: Optional[Timestamp]
    def getArn: ZIO[Any, AwsError, Arn] = AwsError.unwrapOptionField("arn", arn)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getDetails: ZIO[
      Any,
      AwsError,
      zio.aws.dataexchange.model.ResponseDetails.ReadOnly
    ] = AwsError.unwrapOptionField("details", details)
    def getErrors: ZIO[Any, AwsError, List[
      zio.aws.dataexchange.model.JobError.ReadOnly
    ]] = AwsError.unwrapOptionField("errors", errors)
    def getId: ZIO[Any, AwsError, Id] = AwsError.unwrapOptionField("id", id)
    def getState: ZIO[Any, AwsError, zio.aws.dataexchange.model.State] =
      AwsError.unwrapOptionField("state", state)
    def getType: ZIO[Any, AwsError, zio.aws.dataexchange.model.Type] =
      AwsError.unwrapOptionField("type", `type`)
    def getUpdatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("updatedAt", updatedAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dataexchange.model.CreateJobResponse
  ) extends zio.aws.dataexchange.model.CreateJobResponse.ReadOnly {
    override val arn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.dataexchange.model.primitives.Arn(value))
    override val createdAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.dataexchange.model.primitives.Timestamp(value))
    override val details
        : Optional[zio.aws.dataexchange.model.ResponseDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.details())
        .map(value => zio.aws.dataexchange.model.ResponseDetails.wrap(value))
    override val errors
        : Optional[List[zio.aws.dataexchange.model.JobError.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.errors())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.dataexchange.model.JobError.wrap(item)
          }.toList
        )
    override val id: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.dataexchange.model.primitives.Id(value))
    override val state: Optional[zio.aws.dataexchange.model.State] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.dataexchange.model.State.wrap(value))
    override val `type`: Optional[zio.aws.dataexchange.model.Type] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.dataexchange.model.Type.wrap(value))
    override val updatedAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.updatedAt())
      .map(value => zio.aws.dataexchange.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dataexchange.model.CreateJobResponse
  ): zio.aws.dataexchange.model.CreateJobResponse.ReadOnly = new Wrapper(impl)
}
