package zio.aws.dataexchange.model
import zio.aws.dataexchange.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListDataSetsResponse(
    dataSets: Optional[Iterable[zio.aws.dataexchange.model.DataSetEntry]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dataexchange.model.ListDataSetsResponse = {
    import ListDataSetsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dataexchange.model.ListDataSetsResponse
      .builder()
      .optionallyWith(
        dataSets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dataSets)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.dataexchange.model.ListDataSetsResponse.ReadOnly =
    zio.aws.dataexchange.model.ListDataSetsResponse.wrap(buildAwsValue())
}
object ListDataSetsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dataexchange.model.ListDataSetsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dataexchange.model.ListDataSetsResponse =
      zio.aws.dataexchange.model.ListDataSetsResponse(
        dataSets.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def dataSets
        : Optional[List[zio.aws.dataexchange.model.DataSetEntry.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getDataSets: ZIO[Any, AwsError, List[
      zio.aws.dataexchange.model.DataSetEntry.ReadOnly
    ]] = AwsError.unwrapOptionField("dataSets", dataSets)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dataexchange.model.ListDataSetsResponse
  ) extends zio.aws.dataexchange.model.ListDataSetsResponse.ReadOnly {
    override val dataSets
        : Optional[List[zio.aws.dataexchange.model.DataSetEntry.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataSets())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.dataexchange.model.DataSetEntry.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.dataexchange.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dataexchange.model.ListDataSetsResponse
  ): zio.aws.dataexchange.model.ListDataSetsResponse.ReadOnly = new Wrapper(
    impl
  )
}
