package zio.aws.dataexchange.model
import zio.aws.dataexchange.model.primitives.{__string, __double}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class JobError(
    code: zio.aws.dataexchange.model.Code,
    details: Optional[zio.aws.dataexchange.model.Details] = Optional.Absent,
    limitName: Optional[zio.aws.dataexchange.model.JobErrorLimitName] =
      Optional.Absent,
    limitValue: Optional[__double] = Optional.Absent,
    message: __string,
    resourceId: Optional[__string] = Optional.Absent,
    resourceType: Optional[zio.aws.dataexchange.model.JobErrorResourceTypes] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dataexchange.model.JobError = {
    import JobError.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dataexchange.model.JobError
      .builder()
      .code(code.unwrap)
      .optionallyWith(details.map(value => value.buildAwsValue()))(_.details)
      .optionallyWith(limitName.map(value => value.unwrap))(_.limitName)
      .optionallyWith(limitValue.map(value => value: java.lang.Double))(
        _.limitValue
      )
      .message(message: java.lang.String)
      .optionallyWith(resourceId.map(value => value: java.lang.String))(
        _.resourceId
      )
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .build()
  }
  def asReadOnly: zio.aws.dataexchange.model.JobError.ReadOnly =
    zio.aws.dataexchange.model.JobError.wrap(buildAwsValue())
}
object JobError {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dataexchange.model.JobError
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dataexchange.model.JobError =
      zio.aws.dataexchange.model.JobError(
        code,
        details.map(value => value.asEditable),
        limitName.map(value => value),
        limitValue.map(value => value),
        message,
        resourceId.map(value => value),
        resourceType.map(value => value)
      )
    def code: zio.aws.dataexchange.model.Code
    def details: Optional[zio.aws.dataexchange.model.Details.ReadOnly]
    def limitName: Optional[zio.aws.dataexchange.model.JobErrorLimitName]
    def limitValue: Optional[__double]
    def message: __string
    def resourceId: Optional[__string]
    def resourceType: Optional[zio.aws.dataexchange.model.JobErrorResourceTypes]
    def getCode: ZIO[Any, Nothing, zio.aws.dataexchange.model.Code] =
      ZIO.succeed(code)
    def getDetails
        : ZIO[Any, AwsError, zio.aws.dataexchange.model.Details.ReadOnly] =
      AwsError.unwrapOptionField("details", details)
    def getLimitName
        : ZIO[Any, AwsError, zio.aws.dataexchange.model.JobErrorLimitName] =
      AwsError.unwrapOptionField("limitName", limitName)
    def getLimitValue: ZIO[Any, AwsError, __double] =
      AwsError.unwrapOptionField("limitValue", limitValue)
    def getMessage: ZIO[Any, Nothing, __string] = ZIO.succeed(message)
    def getResourceId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("resourceId", resourceId)
    def getResourceType
        : ZIO[Any, AwsError, zio.aws.dataexchange.model.JobErrorResourceTypes] =
      AwsError.unwrapOptionField("resourceType", resourceType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dataexchange.model.JobError
  ) extends zio.aws.dataexchange.model.JobError.ReadOnly {
    override val code: zio.aws.dataexchange.model.Code =
      zio.aws.dataexchange.model.Code.wrap(impl.code())
    override val details
        : Optional[zio.aws.dataexchange.model.Details.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.details())
        .map(value => zio.aws.dataexchange.model.Details.wrap(value))
    override val limitName
        : Optional[zio.aws.dataexchange.model.JobErrorLimitName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.limitName())
        .map(value => zio.aws.dataexchange.model.JobErrorLimitName.wrap(value))
    override val limitValue: Optional[__double] = zio.aws.core.internal
      .optionalFromNullable(impl.limitValue())
      .map(value => value: __double)
    override val message: __string = impl.message(): __string
    override val resourceId: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceId())
      .map(value => value: __string)
    override val resourceType
        : Optional[zio.aws.dataexchange.model.JobErrorResourceTypes] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceType())
        .map(value =>
          zio.aws.dataexchange.model.JobErrorResourceTypes.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.dataexchange.model.JobError
  ): zio.aws.dataexchange.model.JobError.ReadOnly = new Wrapper(impl)
}
