package zio.aws.dataexchange.model
import zio.aws.dataexchange.model.primitives.__string
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ExportServerSideEncryption(
    kmsKeyArn: Optional[__string] = Optional.Absent,
    `type`: zio.aws.dataexchange.model.ServerSideEncryptionTypes
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dataexchange.model.ExportServerSideEncryption = {
    import ExportServerSideEncryption.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dataexchange.model.ExportServerSideEncryption
      .builder()
      .optionallyWith(kmsKeyArn.map(value => value: java.lang.String))(
        _.kmsKeyArn
      )
      .`type`(`type`.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.dataexchange.model.ExportServerSideEncryption.ReadOnly =
    zio.aws.dataexchange.model.ExportServerSideEncryption.wrap(buildAwsValue())
}
object ExportServerSideEncryption {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dataexchange.model.ExportServerSideEncryption
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dataexchange.model.ExportServerSideEncryption =
      zio.aws.dataexchange.model
        .ExportServerSideEncryption(kmsKeyArn.map(value => value), `type`)
    def kmsKeyArn: Optional[__string]
    def `type`: zio.aws.dataexchange.model.ServerSideEncryptionTypes
    def getKmsKeyArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("kmsKeyArn", kmsKeyArn)
    def getType: ZIO[
      Any,
      Nothing,
      zio.aws.dataexchange.model.ServerSideEncryptionTypes
    ] = ZIO.succeed(`type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dataexchange.model.ExportServerSideEncryption
  ) extends zio.aws.dataexchange.model.ExportServerSideEncryption.ReadOnly {
    override val kmsKeyArn: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyArn())
      .map(value => value: __string)
    override val `type`: zio.aws.dataexchange.model.ServerSideEncryptionTypes =
      zio.aws.dataexchange.model.ServerSideEncryptionTypes.wrap(impl.`type`())
  }
  def wrap(
      impl: software.amazon.awssdk.services.dataexchange.model.ExportServerSideEncryption
  ): zio.aws.dataexchange.model.ExportServerSideEncryption.ReadOnly =
    new Wrapper(impl)
}
