package zio.aws.dataexchange.model
import zio.aws.dataexchange.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListDataSetsResponse(
    dataSets: Option[Iterable[zio.aws.dataexchange.model.DataSetEntry]] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dataexchange.model.ListDataSetsResponse = {
    import ListDataSetsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dataexchange.model.ListDataSetsResponse
      .builder()
      .optionallyWith(
        dataSets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dataSets)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.dataexchange.model.ListDataSetsResponse.ReadOnly =
    zio.aws.dataexchange.model.ListDataSetsResponse.wrap(buildAwsValue())
}
object ListDataSetsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dataexchange.model.ListDataSetsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dataexchange.model.ListDataSetsResponse =
      zio.aws.dataexchange.model.ListDataSetsResponse(
        dataSets.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def dataSets: Option[List[zio.aws.dataexchange.model.DataSetEntry.ReadOnly]]
    def nextToken: Option[NextToken]
    def getDataSets: ZIO[Any, AwsError, List[
      zio.aws.dataexchange.model.DataSetEntry.ReadOnly
    ]] = AwsError.unwrapOptionField("dataSets", dataSets)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dataexchange.model.ListDataSetsResponse
  ) extends zio.aws.dataexchange.model.ListDataSetsResponse.ReadOnly {
    override val dataSets
        : Option[List[zio.aws.dataexchange.model.DataSetEntry.ReadOnly]] = scala
      .Option(impl.dataSets())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.dataexchange.model.DataSetEntry.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.dataexchange.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dataexchange.model.ListDataSetsResponse
  ): zio.aws.dataexchange.model.ListDataSetsResponse.ReadOnly = new Wrapper(
    impl
  )
}
